/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.config;

import com.anthonyhilyard.iceberg.Loader;
import com.electronwill.nightconfig.core.AbstractCommentedConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class IcebergConfigSpec
extends UnmodifiableConfigWrapper<UnmodifiableConfig>
implements IConfigSpec<IcebergConfigSpec> {
    private Map<List<String>, String> levelComments;
    private Map<List<String>, String> levelTranslationKeys;
    private UnmodifiableConfig values;
    private Config childConfig;
    private boolean isCorrecting = false;
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private IcebergConfigSpec(UnmodifiableConfig storage, UnmodifiableConfig values, Map<List<String>, String> levelComments, Map<List<String>, String> levelTranslationKeys) {
        super(storage);
        this.values = values;
        this.levelComments = levelComments;
        this.levelTranslationKeys = levelTranslationKeys;
        try {
            Field exceptionHandlerField = FileWatcher.class.getDeclaredField("exceptionHandler");
            UnsafeHacks.setField((Field)exceptionHandlerField, (Object)FileWatcher.defaultInstance(), e -> LogManager.getLogger().warn(Logging.CORE, "An error occurred while reloading config:", (Throwable)e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLevelComment(List<String> path) {
        return this.levelComments.get(path);
    }

    public String getLevelTranslationKey(List<String> path) {
        return this.levelTranslationKeys.get(path);
    }

    public void setConfig(CommentedConfig config) {
        this.childConfig = config;
        if (config != null && !this.isCorrect(config)) {
            String string;
            FileConfig fileConfig;
            if (config instanceof FileConfig) {
                fileConfig = (FileConfig)config;
                string = fileConfig.getNioPath().toString();
            } else {
                string = config.toString();
            }
            String configName = string;
            Loader.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)configName);
            this.correct(config, (action, path, incorrectValue, correctedValue) -> Loader.LOGGER.warn("Incorrect key {} was corrected from {} to its default, {}. {}", (Object)DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> Loader.LOGGER.debug("The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)));
            if (config instanceof FileConfig) {
                fileConfig = (FileConfig)config;
                fileConfig.save();
            }
        }
        this.afterReload();
    }

    public <T> T getRaw(List<String> path) {
        ForgeConfigSpec.ValueSpec valueSpec;
        Object object;
        Object value = super.getRaw(path);
        if (value != null) {
            return (T)value;
        }
        List<String> subPath = path.subList(0, path.size() - 1);
        Object test = super.getRaw(subPath);
        if (test instanceof ForgeConfigSpec.ValueSpec && (object = (valueSpec = (ForgeConfigSpec.ValueSpec)test).getDefault()) instanceof MutableSubconfig) {
            MutableSubconfig subconfig = (MutableSubconfig)((Object)object);
            value = subconfig.getRaw(path.get(path.size() - 1));
            if (value == null) {
                value = subconfig.defaultValueSpec();
            }
            return (T)value;
        }
        return null;
    }

    public void acceptConfig(CommentedConfig data) {
        this.setConfig(data);
    }

    public boolean isCorrecting() {
        return this.isCorrecting;
    }

    public boolean isLoaded() {
        return this.childConfig != null;
    }

    public UnmodifiableConfig getSpec() {
        return this.config;
    }

    public UnmodifiableConfig getValues() {
        return this.values;
    }

    public void afterReload() {
        this.resetCaches(this.getValues().valueMap().values());
    }

    private void resetCaches(Iterable<Object> configValues) {
        configValues.forEach(value -> {
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                configValue.clearCache();
            } else if (value instanceof Config) {
                Config innerConfig = (Config)value;
                this.resetCaches(innerConfig.valueMap().values());
            }
        });
    }

    public void save() {
        Preconditions.checkNotNull((Object)this.childConfig, (Object)"Cannot save config value without assigned Config object present!");
        Config config = this.childConfig;
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            fileConfig.save();
        }
    }

    public synchronized boolean isCorrect(CommentedConfig config) {
        LinkedList<String> parentPath = new LinkedList<String>();
        if (config.valueMap().isEmpty() && config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            File configFile = fileConfig.getFile();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configFile.length() > 0L) {
                return true;
            }
        }
        return this.correct(this.config, config, parentPath, Collections.unmodifiableList(parentPath), (a, b, c, d) -> {}, null, true) == 0;
    }

    public synchronized int correct(CommentedConfig config) {
        return this.correct(config, (action, path, incorrectValue, correctedValue) -> {}, null);
    }

    public synchronized int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener) {
        return this.correct(config, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener) {
        LinkedList<String> parentPath = new LinkedList<String>();
        int ret = -1;
        try {
            this.isCorrecting = true;
            ret = this.correct(this.config, config, parentPath, Collections.unmodifiableList(parentPath), listener, commentListener, false);
        }
        finally {
            this.isCorrecting = false;
        }
        return ret;
    }

    private synchronized int correct(UnmodifiableConfig spec, CommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map specMap = spec.valueMap();
        Map configMap = config.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            ForgeConfigSpec.ValueSpec valueSpec;
            String key = (String)specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            String subConfigComment = null;
            if (specValue instanceof ForgeConfigSpec.ValueSpec && (valueSpec = (ForgeConfigSpec.ValueSpec)specValue).getDefault() instanceof UnmodifiableConfig) {
                subConfigComment = valueSpec.getComment();
                specValue = valueSpec.getDefault();
            }
            if (specValue instanceof UnmodifiableConfig) {
                if (configValue instanceof Config) {
                    CommentedConfig commentedConfig;
                    if ((count += this.correct((UnmodifiableConfig)specValue, configValue instanceof CommentedConfig ? (commentedConfig = (CommentedConfig)configValue) : CommentedConfig.copy((UnmodifiableConfig)((Config)configValue)), parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    if (dryRun) {
                        return 1;
                    }
                    CommentedConfig newValue = config.createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, (Object)newValue);
                    ++count;
                    count += this.correct((UnmodifiableConfig)specValue, newValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                }
                String newComment = subConfigComment == null ? this.levelComments.get(parentPath) : subConfigComment;
                oldComment = config.getComment(key);
                if (!this.stringsMatchIgnoringNewlines(oldComment, newComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)newComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, newComment);
                }
            } else {
                valueSpec = (ForgeConfigSpec.ValueSpec)specValue;
                if (!valueSpec.test(configValue)) {
                    if (dryRun) {
                        return 1;
                    }
                    Object newValue = valueSpec.correct(configValue);
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                }
                if (!this.stringsMatchIgnoringNewlines(oldComment = config.getComment(key), valueSpec.getComment())) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)valueSpec.getComment());
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, valueSpec.getComment());
                }
            }
            parentPath.removeLast();
        }
        Iterator iterator = configMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (spec instanceof MutableSubconfig || specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            iterator.remove();
            parentPath.addLast((String)entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean stringsMatchIgnoringNewlines(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 instanceof String && obj2 instanceof String) {
            String string1 = (String)obj1;
            String string2 = (String)obj2;
            if (string1.length() > 0 && string2.length() > 0) {
                return string1.replaceAll("\r\n", "\n").equals(string2.replaceAll("\r\n", "\n"));
            }
        }
        return Objects.equals(obj1, obj2);
    }

    public static ForgeConfigSpec.ValueSpec createValueSpec(String comment, String langKey, boolean worldRestart, Class<?> clazz, Supplier<?> defaultSupplier, Predicate<Object> validator) {
        Objects.requireNonNull(defaultSupplier, "Default supplier can not be null!");
        Objects.requireNonNull(validator, "Validator can not be null!");
        ForgeConfigSpec.ValueSpec result = (ForgeConfigSpec.ValueSpec)UnsafeHacks.newInstance(ForgeConfigSpec.ValueSpec.class);
        try {
            Field commentField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("comment");
            Field langKeyField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("langKey");
            Field rangeField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("range");
            Field worldRestartField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("worldRestart");
            Field clazzField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("clazz");
            Field supplierField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("supplier");
            Field validatorField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("validator");
            UnsafeHacks.setField((Field)commentField, (Object)result, (Object)comment);
            UnsafeHacks.setField((Field)langKeyField, (Object)result, (Object)langKey);
            UnsafeHacks.setField((Field)rangeField, (Object)result, null);
            UnsafeHacks.setField((Field)worldRestartField, (Object)result, (Object)worldRestart);
            UnsafeHacks.setField((Field)clazzField, (Object)result, clazz);
            UnsafeHacks.setField((Field)supplierField, (Object)result, defaultSupplier);
            UnsafeHacks.setField((Field)validatorField, (Object)result, validator);
        }
        catch (Exception e) {
            Loader.LOGGER.warn("Failed to instantiate ValueSpec!");
            Loader.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public static final class MutableSubconfig
    extends AbstractCommentedConfig {
        private final ConfigFormat<?> configFormat;
        private final Predicate<Object> keyValidator;
        private final Predicate<Object> valueValidator;
        private static ForgeConfigSpec.ValueSpec defaultValueSpec = null;

        MutableSubconfig(UnmodifiableConfig toCopy, ConfigFormat<?> configFormat, boolean concurrent, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            super(toCopy, concurrent);
            this.configFormat = configFormat;
            this.keyValidator = keyValidator;
            this.valueValidator = valueValidator;
        }

        public ForgeConfigSpec.ValueSpec defaultValueSpec() {
            if (defaultValueSpec == null) {
                defaultValueSpec = IcebergConfigSpec.createValueSpec(null, null, false, Object.class, () -> null, this.valueValidator);
            }
            return defaultValueSpec;
        }

        public ConfigFormat<?> configFormat() {
            return this.configFormat;
        }

        public Predicate<Object> keyValidator() {
            return this.keyValidator;
        }

        public Predicate<Object> valueValidator() {
            return this.valueValidator;
        }

        public static MutableSubconfig copy(UnmodifiableConfig config, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return new MutableSubconfig(config, config.configFormat(), false, keyValidator, valueValidator);
        }

        public CommentedConfig createSubConfig() {
            throw new UnsupportedOperationException("Can't make a subconfig of a dynamic subconfig!");
        }

        public AbstractCommentedConfig clone() {
            throw new UnsupportedOperationException("Can't clone a dynamic subconfig!");
        }
    }

    public static class Builder
    extends ForgeConfigSpec.Builder {
        public Builder comment(String comment) {
            return (Builder)super.comment(comment);
        }

        public Builder comment(String ... comment) {
            return (Builder)super.comment(comment);
        }

        public Builder translation(String translationKey) {
            return (Builder)super.translation(translationKey);
        }

        public Builder worldRestart() {
            return (Builder)super.worldRestart();
        }

        public Builder push(String path) {
            return (Builder)super.push(path);
        }

        public Builder push(List<String> path) {
            return (Builder)super.push(path);
        }

        public Builder pop() {
            return (Builder)super.pop();
        }

        public Builder pop(int count) {
            return (Builder)super.pop(count);
        }

        public ForgeConfigSpec.ConfigValue<UnmodifiableConfig> defineSubconfig(String path, UnmodifiableConfig defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.defineSubconfig(IcebergConfigSpec.split(path), defaultValue, keyValidator, valueValidator);
        }

        public ForgeConfigSpec.ConfigValue<UnmodifiableConfig> defineSubconfig(List<String> path, UnmodifiableConfig defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.defineSubconfig(path, () -> defaultValue, keyValidator, valueValidator);
        }

        public ForgeConfigSpec.ConfigValue<UnmodifiableConfig> defineSubconfig(String path, Supplier<UnmodifiableConfig> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.defineSubconfig(IcebergConfigSpec.split(path), defaultSupplier, keyValidator, valueValidator);
        }

        public ForgeConfigSpec.ConfigValue<UnmodifiableConfig> defineSubconfig(List<String> path, Supplier<UnmodifiableConfig> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            UnmodifiableConfig defaultConfig = defaultSupplier.get();
            return this.define(path, () -> MutableSubconfig.copy(defaultConfig, keyValidator, valueValidator), o -> o != null);
        }

        private IcebergConfigSpec finishBuild() {
            IcebergConfigSpec result = null;
            try {
                Field valuesField = ForgeConfigSpec.Builder.class.getDeclaredField("values");
                Field storageField = ForgeConfigSpec.Builder.class.getDeclaredField("storage");
                Field levelCommentsField = ForgeConfigSpec.Builder.class.getDeclaredField("levelComments");
                Field levelTranslationKeysField = ForgeConfigSpec.Builder.class.getDeclaredField("levelTranslationKeys");
                List values = (List)UnsafeHacks.getField((Field)valuesField, (Object)((Object)this));
                Config storage = (Config)UnsafeHacks.getField((Field)storageField, (Object)((Object)this));
                Map levelComments = (Map)UnsafeHacks.getField((Field)levelCommentsField, (Object)((Object)this));
                Map levelTranslationKeys = (Map)UnsafeHacks.getField((Field)levelTranslationKeysField, (Object)((Object)this));
                Config valueCfg = Config.of((Supplier)Config.getDefaultMapCreator((boolean)true, (boolean)true), (ConfigFormat)InMemoryFormat.withSupport(ForgeConfigSpec.ConfigValue.class::isAssignableFrom));
                values.forEach(v -> valueCfg.set(v.getPath(), v));
                IcebergConfigSpec ret = new IcebergConfigSpec((UnmodifiableConfig)storage, (UnmodifiableConfig)valueCfg, levelComments, levelTranslationKeys);
                values.forEach(v -> {
                    try {
                        Field specField = ForgeConfigSpec.ConfigValue.class.getDeclaredField("spec");
                        UnsafeHacks.setField((Field)specField, (Object)v, (Object)((Object)ret));
                    }
                    catch (Exception e) {
                        Loader.LOGGER.warn("Failed to create spec field {}!", (Object)v.toString());
                        Loader.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                });
                result = ret;
            }
            catch (Exception e) {
                Loader.LOGGER.warn("Failed to build IcebergConfigSpec!");
                Loader.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return result;
        }

        <T> Pair<T, IcebergConfigSpec> finish(Function<Builder, T> consumer) {
            T o = consumer.apply(this);
            return Pair.of(o, (Object)((Object)this.finishBuild()));
        }

        @Deprecated
        public <T> Pair<T, ForgeConfigSpec> configure(Function<ForgeConfigSpec.Builder, T> consumer) {
            throw new UnsupportedOperationException("Configure method not supported.  Use IcebergConfig instead.");
        }

        @Deprecated
        public ForgeConfigSpec build() {
            throw new UnsupportedOperationException("Build method not supported.  Use IcebergConfig instead.");
        }
    }
}

