/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.AbstractMRContainerMenu;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;

public class ModuleMenu
extends AbstractMRContainerMenu {
    public static final int AUGMENT_START = 9;
    private static final int INV_START = 13;
    private static final int INV_END = 39;
    private static final int HOTBAR_START = 40;
    private static final int HOTBAR_END = 48;
    private static final int PLAYER_INV_Y = 116;
    private static final int PLAYER_INV_X = 16;
    private static final int PLAYER_HOTBAR_Y = 174;
    private final BaseModuleHandler.ModuleFilterHandler filterHandler;
    private final AugmentHandler augmentHandler;
    private final int currentSlot;
    protected final ModularRouterBlockEntity router;
    private final MFLocator locator;

    public ModuleMenu(int windowId, Inventory inv, FriendlyByteBuf extra) {
        this((MenuType)ModMenuTypes.BASE_MODULE_MENU.get(), windowId, inv, MFLocator.fromBuffer(extra));
    }

    public ModuleMenu(MenuType type, int windowId, Inventory inv, FriendlyByteBuf extra) {
        this(type, windowId, inv, MFLocator.fromBuffer(extra));
    }

    public ModuleMenu(MenuType type, int windowId, Inventory inv, MFLocator locator) {
        super(type, windowId);
        int i;
        this.locator = locator;
        this.router = locator.getRouter(inv.f_35978_.f_19853_).orElse(null);
        assert (this.router != null || locator.hand != null);
        ItemStack moduleStack = locator.getModuleStack(inv.f_35978_);
        this.filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, this.router);
        this.augmentHandler = new AugmentHandler(moduleStack, this.router);
        this.currentSlot = inv.f_35977_ + 40;
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new FilterSlot((IItemHandler)this.filterHandler, i, 8 + 18 * (i % 3), 17 + 18 * (i / 3)));
        }
        for (i = 0; i < 4; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.augmentHandler, i, 78 + 18 * (i % 2), 75 + 18 * (i / 2)));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 16 + j * 18, 116 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 16 + i * 18, 174));
        }
    }

    public MFLocator getLocator() {
        return this.locator;
    }

    public ModularRouterBlockEntity getRouter() {
        return this.router;
    }

    protected void transferStackInExtraSlot(Player player, int index) {
    }

    protected void slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, Player player) {
    }

    public boolean m_6875_(Player playerIn) {
        return this.router == null || !this.router.m_58901_();
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot srcSlot = (Slot)this.f_38839_.get(index);
        if (srcSlot.m_6657_()) {
            if (index < 9) {
                srcSlot.m_5852_(ItemStack.f_41583_);
            } else if (index < 13) {
                ItemStack stackInSlot = srcSlot.m_7993_();
                if (!this.m_38903_(stackInSlot, 13, 49, false)) {
                    return ItemStack.f_41583_;
                }
                srcSlot.m_5852_(stackInSlot);
                this.m_38946_();
            } else if (index <= 48) {
                ItemStack stackInSlot = srcSlot.m_7993_();
                if (stackInSlot.m_41720_() instanceof AugmentItem && this.augmentHandler.getHolderStack().m_41613_() == 1) {
                    if (!this.m_38903_(stackInSlot, 9, 13, false)) {
                        return ItemStack.f_41583_;
                    }
                    this.m_38946_();
                } else {
                    ItemStack stack = stackInSlot.m_41777_();
                    stack.m_41764_(1);
                    int firstFree = -1;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack0 = this.filterHandler.getStackInSlot(i);
                        if (ItemStack.m_41746_((ItemStack)stack0, (ItemStack)stack)) {
                            firstFree = i;
                            break;
                        }
                        if (firstFree >= 0 || !stack0.m_41619_() || !this.filterHandler.isItemValid(i, stack)) continue;
                        firstFree = i;
                    }
                    if (firstFree >= 0) {
                        ((Slot)this.f_38839_.get(firstFree)).m_5852_(stack);
                        srcSlot.m_5852_(stackInSlot);
                    }
                }
            } else {
                this.transferStackInExtraSlot(player, index);
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slot, int dragType, ClickType clickTypeIn, Player player) {
        boolean forceUpdate = false;
        if (slot > 48) {
            this.slotClickExtraSlot(slot, dragType, clickTypeIn, player);
            return;
        }
        if (slot >= 9 && slot < 13 && this.augmentHandler.getHolderStack().m_41613_() > 1) {
            return;
        }
        switch (clickTypeIn) {
            case PICKUP: {
                if (this.router == null && slot == this.currentSlot) {
                    return;
                }
                if (slot >= 0 && slot < 9) {
                    Slot s = (Slot)this.f_38839_.get(slot);
                    ItemStack stackOnCursor = this.m_142621_();
                    if (stackOnCursor.m_41619_() || this.isItemOKForFilter(stackOnCursor, slot)) {
                        s.m_5852_(stackOnCursor.m_41619_() ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)stackOnCursor, (int)1));
                    }
                    return;
                }
                if (slot >= 9 && slot < 13 && this.augmentHandler.getHolderStack().m_41613_() == 1) {
                    forceUpdate = true;
                }
            }
            case THROW: {
                if (slot >= 0 && slot < 9) {
                    return;
                }
                if (slot < 9 || slot >= 13 || this.augmentHandler.getHolderStack().m_41613_() != 1) break;
                forceUpdate = true;
            }
        }
        super.m_150399_(slot, dragType, clickTypeIn, player);
        if (forceUpdate) {
            ((Slot)this.f_38839_.get(slot)).m_5852_(((Slot)this.f_38839_.get(slot)).m_7993_());
            this.m_38946_();
        }
    }

    private boolean isItemOKForFilter(ItemStack stack, int slot) {
        if (this.filterHandler.isItemValid(slot, stack)) {
            for (int i = 0; i < this.filterHandler.getSlots(); ++i) {
                if (this.filterHandler.getStackInSlot(i).m_41720_() != stack.m_41720_() || stack.m_41720_() instanceof SmartFilterItem) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean m_5622_(Slot p_94531_1_) {
        return false;
    }
}

