/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemStackHandler;

public class BufferHandler
extends ItemStackHandler {
    private final ModularRouterBlockEntity router;
    private boolean hasFluidCap;
    private boolean hasEnergyCap;
    private final IFluidHandler adapter = new FluidItemAdapter(0);
    private final LazyOptional<IFluidHandler> fluidAdapter = LazyOptional.of(() -> this.adapter);

    public BufferHandler(ModularRouterBlockEntity router) {
        super(router.getBufferSlotCount());
        this.router = router;
        this.hasFluidCap = this.hasCap(this.getStackInSlot(0), ForgeCapabilities.FLUID_HANDLER_ITEM);
        this.hasEnergyCap = this.hasCap(this.getStackInSlot(0), ForgeCapabilities.ENERGY);
    }

    public void onContentsChanged(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        boolean newFluidCap = this.hasCap(stack, ForgeCapabilities.FLUID_HANDLER_ITEM);
        boolean newEnergyCap = this.hasCap(stack, ForgeCapabilities.ENERGY);
        if (newFluidCap != this.hasFluidCap || newEnergyCap != this.hasEnergyCap) {
            this.router.nonNullLevel().m_46672_(this.router.m_58899_(), (Block)ModBlocks.MODULAR_ROUTER.get());
        }
        this.hasFluidCap = newFluidCap;
        this.hasEnergyCap = newEnergyCap;
        this.router.m_6596_();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        ItemStack stack = this.getStackInSlot(0);
        this.hasFluidCap = this.hasCap(stack, ForgeCapabilities.FLUID_HANDLER_ITEM);
        this.hasEnergyCap = this.hasCap(stack, ForgeCapabilities.ENERGY);
    }

    public LazyOptional<IFluidHandlerItem> getFluidItemCapability() {
        ItemStack stack = this.getStackInSlot(0);
        return stack.m_41613_() == 1 ? this.getStackInSlot(0).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM) : LazyOptional.empty();
    }

    public LazyOptional<IFluidHandler> getFluidCapability() {
        return this.hasFluidCap ? this.fluidAdapter : LazyOptional.empty();
    }

    public LazyOptional<IEnergyStorage> getEnergyCapability() {
        return this.getStackInSlot(0).getCapability(ForgeCapabilities.ENERGY);
    }

    private boolean hasCap(ItemStack stack, Capability<?> cap) {
        return stack.m_41613_() == 1 && stack.getCapability(cap).isPresent();
    }

    public void invalidateCaps() {
        this.getFluidCapability().invalidate();
        this.getEnergyCapability().invalidate();
    }

    private class FluidItemAdapter
    implements IFluidHandler {
        private final int slot;

        FluidItemAdapter(int slot) {
            this.slot = slot;
        }

        public int getTanks() {
            return BufferHandler.this.getFluidItemCapability().map(IFluidHandler::getTanks).orElse(0);
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return BufferHandler.this.getFluidItemCapability().map(h -> h.getFluidInTank(tank)).orElse(FluidStack.EMPTY);
        }

        public int getTankCapacity(int tank) {
            return BufferHandler.this.getFluidItemCapability().map(h -> h.getTankCapacity(tank)).orElse(0);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return BufferHandler.this.getFluidItemCapability().map(h -> h.isFluidValid(tank, stack)).orElse(false);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return BufferHandler.this.getFluidItemCapability().map(h -> {
                int filled = h.fill(resource, action);
                if (action.execute() && filled != 0) {
                    BufferHandler.this.setStackInSlot(this.slot, h.getContainer());
                }
                return filled;
            }).orElse(0);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return BufferHandler.this.getFluidItemCapability().map(h -> {
                FluidStack drained = h.drain(resource, action);
                if (action.execute() && !drained.isEmpty()) {
                    BufferHandler.this.setStackInSlot(this.slot, h.getContainer());
                }
                return drained;
            }).orElse(FluidStack.EMPTY);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return BufferHandler.this.getFluidItemCapability().map(h -> {
                FluidStack drained = h.drain(maxDrain, action);
                if (action.execute() && !drained.isEmpty()) {
                    BufferHandler.this.setStackInSlot(this.slot, h.getContainer());
                }
                return drained;
            }).orElse(FluidStack.EMPTY);
        }
    }
}

