/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public abstract class TargetedModule
extends ModuleItem {
    private static final String NBT_TARGET = "Target";
    private static final String NBT_MULTI_TARGET = "MultiTarget";

    TargetedModule(Item.Properties props, BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler) {
        super(props, compiler);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ctx.m_43723_() != null && ctx.m_43723_().m_6047_() && this.isValidTarget(ctx)) {
            if (this.getMaxTargets() == 1) {
                this.handleSingleTarget(ctx.m_43722_(), ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_());
            } else {
                this.handleMultiTarget(ctx.m_43722_(), ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isValidTarget(UseOnContext ctx) {
        return InventoryUtils.getInventory(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_()).isPresent();
    }

    private void handleSingleTarget(ItemStack stack, Player player, Level world, BlockPos pos, Direction face) {
        if (!world.f_46443_) {
            TargetedModule.setTarget(stack, world, pos, face);
            ModuleTarget tgt = TargetedModule.getTarget(stack, true);
            if (tgt != null) {
                MutableComponent msg = Component.m_237115_((String)"modularrouters.chatText.misc.targetSet").m_7220_(tgt.getTextComponent());
                player.m_5661_((Component)msg.m_130940_(ChatFormatting.YELLOW), true);
                world.m_5594_(null, pos, (SoundEvent)ModSounds.SUCCESS.get(), SoundSource.BLOCKS, 1.0f, 1.3f);
            }
        }
    }

    private void handleMultiTarget(ItemStack stack, Player player, Level world, BlockPos pos, Direction face) {
        if (!world.f_46443_) {
            boolean removing = false;
            String invName = BlockUtil.getBlockName(world, pos);
            GlobalPos gPos = MiscUtil.makeGlobalPos(world, pos);
            ModuleTarget tgt = new ModuleTarget(gPos, face, invName);
            Set<ModuleTarget> targets = TargetedModule.getTargets(stack, true);
            if (targets.contains(tgt)) {
                targets.remove(tgt);
                removing = true;
                player.m_5661_((Component)Component.m_237110_((String)"modularrouters.chatText.misc.targetRemoved", (Object[])new Object[]{targets.size(), this.getMaxTargets()}).m_7220_(tgt.getTextComponent()).m_130940_(ChatFormatting.YELLOW), true);
            } else if (targets.size() < this.getMaxTargets()) {
                targets.add(tgt);
                player.m_5661_((Component)Component.m_237110_((String)"modularrouters.chatText.misc.targetAdded", (Object[])new Object[]{targets.size(), this.getMaxTargets()}).m_7220_(tgt.getTextComponent()).m_130940_(ChatFormatting.YELLOW), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"modularrouters.chatText.misc.tooManyTargets", (Object[])new Object[]{this.getMaxTargets()}).m_130940_(ChatFormatting.RED), true);
                world.m_5594_(null, pos, (SoundEvent)ModSounds.ERROR.get(), SoundSource.BLOCKS, 1.0f, 1.3f);
                return;
            }
            world.m_5594_(null, pos, (SoundEvent)ModSounds.SUCCESS.get(), SoundSource.BLOCKS, 1.0f, removing ? 1.1f : 1.3f);
            TargetedModule.setTargets(stack, targets);
        }
    }

    @Override
    public void addUsageInformation(ItemStack itemstack, List<Component> list) {
        super.addUsageInformation(itemstack, list);
        MiscUtil.appendMultilineText(list, ChatFormatting.YELLOW, this.getMaxTargets() > 1 ? "modularrouters.itemText.targetingHintMulti" : "modularrouters.itemText.targetingHint", new Object[0]);
    }

    @Override
    protected void addSettingsInformation(ItemStack itemstack, List<Component> list) {
        super.addSettingsInformation(itemstack, list);
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(itemstack, false) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(itemstack)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            MutableComponent msg = Component.m_237113_((String)"\u25b6 ").m_7220_((Component)MiscUtil.asFormattable(target.getTextComponent()).m_130940_(ChatFormatting.WHITE));
            list.add((Component)msg);
            ClientUtil.getOpenItemRouter().ifPresent(router -> {
                ModuleTarget moduleTarget = new ModuleTarget(router.getGlobalPos());
                TargetValidation val = this.validateTarget(itemstack, moduleTarget, target, false);
                if (val != TargetValidation.OK) {
                    list.add((Component)ClientUtil.xlate(val.translationKey(), new Object[0]).m_130940_(val.getColor()));
                }
            });
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> onSneakRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_ && TargetedModule.getTarget(stack) != null && this.getMaxTargets() == 1) {
            TargetedModule.setTarget(stack, world, null, null);
            world.m_5594_(null, new BlockPos(player.m_20182_()), (SoundEvent)ModSounds.SUCCESS.get(), SoundSource.BLOCKS, 1.0f, 1.1f);
            player.m_5661_((Component)Component.m_237115_((String)"modularrouters.chatText.misc.targetCleared").m_130940_(ChatFormatting.YELLOW), true);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private static void setTarget(ItemStack stack, Level world, BlockPos pos, Direction face) {
        if (world.f_46443_) {
            ModularRouters.LOGGER.warn("TargetModule.setTarget() should not be called client-side!");
            return;
        }
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        if (pos == null) {
            compound.m_128473_(NBT_TARGET);
        } else {
            ModuleTarget mt = new ModuleTarget(MiscUtil.makeGlobalPos(world, pos), face, BlockUtil.getBlockName(world, pos));
            compound.m_128365_(NBT_TARGET, (Tag)mt.toNBT());
        }
        stack.m_41784_().m_128365_("modularrouters", (Tag)compound);
    }

    public static ModuleTarget getTarget(ItemStack stack) {
        return TargetedModule.getTarget(stack, false);
    }

    public static ModuleTarget getTarget(ItemStack stack, boolean checkBlockName) {
        CompoundTag compound = stack.m_41737_("modularrouters");
        if (compound != null && compound.m_128435_(NBT_TARGET) == 10) {
            ModuleTarget newTarget;
            ModuleTarget target = ModuleTarget.fromNBT(compound.m_128469_(NBT_TARGET));
            if (checkBlockName && (newTarget = TargetedModule.updateTargetBlockName(stack, target)) != null) {
                return newTarget;
            }
            return target;
        }
        return null;
    }

    public static Set<ModuleTarget> getTargets(ItemStack stack, boolean checkBlockName) {
        HashSet result = Sets.newHashSet();
        CompoundTag compound = stack.m_41737_("modularrouters");
        if (compound != null && compound.m_128435_(NBT_MULTI_TARGET) == 9) {
            ListTag list = compound.m_128437_(NBT_MULTI_TARGET, 10);
            for (int i = 0; i < list.size(); ++i) {
                ModuleTarget target = ModuleTarget.fromNBT(list.m_128728_(i));
                if (checkBlockName) {
                    ModuleTarget newTarget = TargetedModule.updateTargetBlockName(stack, target);
                    result.add(newTarget != null ? newTarget : target);
                    continue;
                }
                result.add(target);
            }
        }
        return result;
    }

    private static void setTargets(ItemStack stack, Set<ModuleTarget> targets) {
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        ListTag list = new ListTag();
        for (ModuleTarget target : targets) {
            list.add((Object)target.toNBT());
        }
        compound.m_128365_(NBT_MULTI_TARGET, (Tag)list);
        stack.m_41784_().m_128365_("modularrouters", (Tag)compound);
    }

    private static ModuleTarget updateTargetBlockName(ItemStack stack, ModuleTarget target) {
        String invName;
        ServerLevel w = MiscUtil.getWorldForGlobalPos(target.gPos);
        BlockPos pos = target.gPos.m_122646_();
        if (w != null && w.m_7726_().m_5563_(pos.m_123341_() >> 4, pos.m_123343_() >> 4) && !target.blockTranslationKey.equals(invName = BlockUtil.getBlockName((Level)w, pos))) {
            TargetedModule.setTarget(stack, (Level)w, pos, target.face);
            return new ModuleTarget(target.gPos, target.face, invName);
        }
        return null;
    }

    @Override
    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
        ModuleTarget src = new ModuleTarget(MiscUtil.makeGlobalPos(player.m_20193_(), new BlockPos(player.m_20182_())));
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(stack, true) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(stack, true)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            TargetValidation v = this.validateTarget(stack, src, target, true);
            MutableComponent msg = MiscUtil.asFormattable(target.getTextComponent()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)v.translationKey()).m_130940_(v.getColor()));
            player.m_5661_((Component)msg, false);
        }
    }

    private TargetValidation validateTarget(ItemStack moduleStack, ModuleTarget src, ModuleTarget dst, boolean validateBlocks) {
        if (this.isRangeLimited() && (!src.isSameWorld(dst) || src.gPos.m_122646_().m_123331_((Vec3i)dst.gPos.m_122646_()) > (double)this.maxDistanceSq(moduleStack))) {
            return TargetValidation.OUT_OF_RANGE;
        }
        if (validateBlocks) {
            ServerLevel w = MiscUtil.getWorldForGlobalPos(dst.gPos);
            if (w == null || !w.m_7726_().m_5563_(dst.gPos.m_122646_().m_123341_() >> 4, dst.gPos.m_122646_().m_123343_() >> 4)) {
                return TargetValidation.NOT_LOADED;
            }
            if (w.m_7702_(dst.gPos.m_122646_()) == null) {
                return TargetValidation.NOT_INVENTORY;
            }
            if (this.badDimension(dst.gPos.m_122640_().m_135782_()) || this.badDimension(src.gPos.m_122640_().m_135782_())) {
                return TargetValidation.BAD_DIMENSION;
            }
        }
        return TargetValidation.OK;
    }

    protected boolean badDimension(ResourceLocation dimId) {
        return false;
    }

    private int maxDistanceSq(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IRangedModule) {
            IRangedModule rangedModule = (IRangedModule)item;
            int r = rangedModule.getCurrentRange(stack);
            return r * r;
        }
        return 0;
    }

    protected int getMaxTargets() {
        return 1;
    }

    protected boolean isRangeLimited() {
        return true;
    }

    static enum TargetValidation {
        OK,
        OUT_OF_RANGE,
        NOT_LOADED,
        NOT_INVENTORY,
        BAD_DIMENSION;


        ChatFormatting getColor() {
            return this == OK ? ChatFormatting.GREEN : ChatFormatting.RED;
        }

        String translationKey() {
            return "modularrouters.chatText.targetValidation." + this;
        }
    }
}

