/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerGuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularGuiContainer<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements ContainerScreenAccess<T> {
    public final ModularGui modularGui;
    private boolean renderingSlots = false;

    public ModularGuiContainer(T containerMenu, Inventory inventory, ContainerGuiProvider<T> provider) {
        super(containerMenu, inventory, (Component)Component.m_237119_());
        provider.setMenuAccess(this);
        this.modularGui = new ModularGui(provider);
        this.modularGui.setScreen((Screen)this);
    }

    public ModularGui getModularGui() {
        return this.modularGui;
    }

    @NotNull
    public Component m_96636_() {
        return this.modularGui.getGuiTitle();
    }

    public boolean m_6913_() {
        return this.modularGui.closeOnEscape();
    }

    protected void m_7856_() {
        this.modularGui.onScreenInit(this.f_96541_, this.f_96547_, this.f_96543_, this.f_96544_);
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.modularGui.onScreenInit(minecraft, this.f_96547_, width, height);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        GuiElement<?> root = this.modularGui.getRoot();
        this.f_97736_ = (int)root.getValue(GeoParam.TOP);
        this.f_97735_ = (int)root.getValue(GeoParam.LEFT);
        this.f_97726_ = (int)root.getValue(GeoParam.WIDTH);
        this.f_97727_ = (int)root.getValue(GeoParam.HEIGHT);
        this.modularGui.setVanillaSlotRendering(false);
        if (this.modularGui.renderBackground()) {
            this.m_7333_(poseStack);
        }
        GuiRender render = new GuiRender(this.f_96541_, poseStack, this.f_96541_.m_91269_().m_110104_());
        this.modularGui.render(render, partialTicks);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (!this.handleFloatingItemRender(render, mouseX, mouseY) && !this.renderHoveredStackToolTip(render, mouseX, mouseY)) {
            this.modularGui.renderOverlay(render, partialTicks);
        }
    }

    protected boolean handleFloatingItemRender(GuiRender render, int mouseX, int mouseY) {
        ItemStack stack;
        if (this.modularGui.vanillaSlotRendering()) {
            return false;
        }
        boolean ret = false;
        ItemStack itemStack = stack = this.f_97711_.m_41619_() ? this.f_97732_.m_142621_() : this.f_97711_;
        if (!stack.m_41619_()) {
            int yOffset = this.f_97711_.m_41619_() ? 8 : 16;
            String countOverride = null;
            if (!this.f_97711_.m_41619_() && this.f_97710_) {
                stack = stack.m_41777_();
                stack.m_41764_(Mth.m_14167_((float)((float)stack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                stack = stack.m_41777_();
                stack.m_41764_(this.f_97720_);
                if (stack.m_41619_()) {
                    countOverride = ChatFormatting.YELLOW + "0";
                }
            }
            this.renderFloatingItem(render, stack, mouseX - 8, mouseY - yOffset, countOverride);
            ret = true;
        }
        if (!this.f_97715_.m_41619_()) {
            float anim = (float)(Util.m_137550_() - this.f_97714_) / 100.0f;
            if (anim >= 1.0f) {
                anim = 1.0f;
                this.f_97715_ = ItemStack.f_41583_;
            }
            int xDist = this.f_97707_.f_40220_ - this.f_97712_;
            int yDist = this.f_97707_.f_40221_ - this.f_97713_;
            int xPos = this.f_97712_ + (int)((float)xDist * anim);
            int yPos = this.f_97713_ + (int)((float)yDist * anim);
            this.renderFloatingItem(render, this.f_97715_, xPos + this.f_97735_, yPos + this.f_97736_, null);
            ret = true;
        }
        return ret;
    }

    protected boolean renderHoveredStackToolTip(GuiRender guiGraphics, int mouseX, int mouseY) {
        if (this.f_97732_.m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            GuiElement<?> handler = this.modularGui.getSlotHandler(this.f_97734_);
            if (handler != null && (handler.blockMouseOver(handler, mouseX, mouseY) || !handler.isMouseOver())) {
                return false;
            }
            ItemStack itemStack = this.f_97734_.m_7993_();
            guiGraphics.toolTipWithImage(this.m_96555_(itemStack), itemStack.m_150921_(), mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected void m_181908_() {
        this.modularGui.tick();
    }

    public void m_7379_() {
        super.m_7379_();
        this.modularGui.onGuiClose();
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.modularGui.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.modularGui.mouseClicked(mouseX, mouseY, button) || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.modularGui.mouseReleased(mouseX, mouseY, button) || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.modularGui.mouseScrolled(mouseX, mouseY, scroll) || super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        return this.modularGui.keyPressed(key, scancode, modifiers) || super.m_7933_(key, scancode, modifiers);
    }

    public boolean m_7920_(int key, int scancode, int modifiers) {
        return this.modularGui.keyReleased(key, scancode, modifiers) || super.m_7920_(key, scancode, modifiers);
    }

    public boolean m_5534_(char character, int modifiers) {
        return this.modularGui.charTyped(character, modifiers) || super.m_5534_(character, modifiers);
    }

    protected void m_7286_(PoseStack poseStack, float f, int i, int j) {
    }

    public void m_97799_(PoseStack poseStack, Slot slot) {
        if (this.modularGui.vanillaSlotRendering()) {
            super.m_97799_(poseStack, slot);
        } else {
            this.renderingSlots = true;
        }
    }

    @Override
    public void renderSlot(GuiRender render, Slot slot) {
        if (this.modularGui.vanillaSlotRendering()) {
            return;
        }
        int slotX = slot.f_40220_ + this.f_97735_;
        int slotY = slot.f_40221_ + this.f_97736_;
        ItemStack itemStack = slot.m_7993_();
        boolean dragingToSlot = false;
        boolean dontRenderItem = slot == this.f_97706_ && !this.f_97711_.m_41619_() && !this.f_97710_;
        ItemStack itemStack2 = this.f_97732_.m_142621_();
        String countString = null;
        if (slot == this.f_97706_ && !this.f_97711_.m_41619_() && this.f_97710_ && !itemStack.m_41619_()) {
            itemStack = itemStack.m_41777_();
            itemStack.m_41764_(itemStack.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(slot) && !itemStack2.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)itemStack2, (boolean)true) && this.f_97732_.m_5622_(slot)) {
                itemStack = itemStack2.m_41777_();
                dragingToSlot = true;
                AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)itemStack, (int)(slot.m_7993_().m_41619_() ? 0 : slot.m_7993_().m_41613_()));
                int k = Math.min(itemStack.m_41741_(), slot.m_5866_(itemStack));
                if (itemStack.m_41613_() > k) {
                    countString = ChatFormatting.YELLOW.toString() + k;
                    itemStack.m_41764_(k);
                }
            } else {
                this.f_97737_.remove(slot);
                this.m_97818_();
            }
        }
        if (!dontRenderItem) {
            if (dragingToSlot) {
                render.fill(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
            }
            render.renderItem(itemStack, slotX, (double)slotY, 16.0, slot.f_40220_ + slot.f_40221_ * this.f_97726_);
            render.renderItemDecorations(itemStack, (double)slotX, (double)slotY, countString);
        }
    }

    public boolean m_97774_(Slot pSlot, double pMouseX, double pMouseY) {
        boolean ret = super.m_97774_(pSlot, pMouseX, pMouseY);
        if (ret && this.renderingSlots && pSlot.m_6659_()) {
            this.f_97734_ = pSlot;
            return false;
        }
        return ret;
    }

    protected void m_7027_(PoseStack poseStack, int i, int j) {
        this.renderingSlots = false;
    }

    public void m_97782_(ItemStack itemStack, int i, int j, String string) {
        if (this.modularGui.vanillaSlotRendering()) {
            super.m_97782_(itemStack, i, j, string);
        }
    }

    public void renderFloatingItem(GuiRender render, ItemStack itemStack, int x, int y, String string) {
        render.pose().m_85836_();
        render.pose().m_85837_(0.0, 0.0, 50.0);
        render.renderItem(itemStack, x, y);
        render.renderItemDecorations(itemStack, (double)x, (double)(y - (this.f_97711_.m_41619_() ? 0 : 8)), string);
        render.pose().m_85849_();
    }

    @Nullable
    public Slot m_97744_(double mouseX, double mouseY) {
        Slot slot = super.m_97744_(mouseX, mouseY);
        if (slot == null) {
            return null;
        }
        GuiElement<?> handler = this.modularGui.getSlotHandler(slot);
        if (!(handler == null || handler.isEnabled() && handler.isMouseOver())) {
            return null;
        }
        return slot;
    }

    protected void m_6597_(Slot slot, int i, int j, ClickType clickType) {
        GuiElement<?> handler;
        if (slot != null && (handler = this.modularGui.getSlotHandler(slot)) != null && !handler.isEnabled()) {
            return;
        }
        super.m_6597_(slot, i, j, clickType);
    }
}

