/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiEntityRenderer
extends GuiElement<GuiEntityRenderer>
implements BackgroundRender {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private static final List<ResourceLocation> invalidEntities = new ArrayList<ResourceLocation>();
    private Supplier<Float> rotationSpeed = () -> Float.valueOf(1.0f);
    private Supplier<Float> lockedRotation = () -> Float.valueOf(0.0f);
    private Entity entity;
    private ResourceLocation entityName;
    private boolean invalidEntity = false;
    private Supplier<Boolean> rotationLocked = () -> false;
    private Supplier<Boolean> trackMouse = () -> false;
    private Supplier<Boolean> drawName = () -> false;
    private int tick = 0;
    public boolean force2dSize = false;
    public int nameOffset = -15;

    public GuiEntityRenderer(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiEntityRenderer setEntity(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            this.invalidEntity = true;
            return this;
        }
        this.entityName = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
        this.invalidEntity = invalidEntities.contains(this.entityName);
        return this;
    }

    public GuiEntityRenderer setEntity(ResourceLocation entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> {
            EntityType type = (EntityType)Registry.f_122826_.m_7745_(entity);
            return type.m_20615_((Level)this.mc().f_91073_);
        });
        boolean bl = this.invalidEntity = this.entity == null;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = () -> Float.valueOf(rotationSpeed);
        return this;
    }

    public GuiEntityRenderer setRotationSpeed(Supplier<Float> rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed.get().floatValue();
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = () -> Float.valueOf(lockedRotation);
        return this;
    }

    public GuiEntityRenderer setLockedRotation(Supplier<Float> lockedRotation) {
        this.lockedRotation = lockedRotation;
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation.get().floatValue();
    }

    public GuiEntityRenderer setRotationLocked(boolean rotationLocked) {
        this.rotationLocked = () -> rotationLocked;
        return this;
    }

    public GuiEntityRenderer setRotationLocked(Supplier<Boolean> rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public boolean isRotationLocked() {
        return this.rotationLocked.get();
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = () -> trackMouse;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(Supplier<Boolean> trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public boolean isTrackMouse() {
        return this.trackMouse.get();
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = () -> drawName;
        return this;
    }

    public GuiEntityRenderer setDrawName(Supplier<Boolean> drawName) {
        this.drawName = drawName;
        return this;
    }

    public boolean isDrawName() {
        return this.drawName.get();
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public double getBackgroundDepth() {
        Rectangle rect = this.getRectangle();
        if (this.invalidEntity || this.entity == null) {
            return 0.01;
        }
        float scale = (float)(this.force2dSize ? Math.min(rect.height() / (double)this.entity.m_20206_(), rect.width() / (double)this.entity.m_20205_()) : rect.height() / (double)this.entity.m_20206_());
        if (Float.isInfinite(scale)) {
            scale = 1.0f;
        }
        return scale * 2.0f;
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.invalidEntity) {
            return;
        }
        try {
            if (this.entity != null) {
                if (this.isDrawName()) {
                    Component name = this.entity.m_5446_();
                    int width = this.font().m_92852_((FormattedText)name);
                    render.rect(this.xCenter() - (double)width / 2.0 - 1.0, this.yMin() + (double)this.nameOffset - 1.0, width + 2, 10.0, 0x64000000);
                    render.drawString(name, this.xCenter() - (double)width / 2.0, this.yMin() + (double)this.nameOffset, -1, false);
                }
                Rectangle rect = this.getRectangle();
                float scale = (float)(this.force2dSize ? Math.min(rect.height() / (double)this.entity.m_20206_(), rect.width() / (double)this.entity.m_20205_()) : rect.height() / (double)this.entity.m_20206_());
                float xPos = (float)(rect.x() + rect.width() / 2.0);
                float yPos = (float)(this.yMin() + this.ySize() / 2.0 + rect.height() / 2.0);
                float rotation = this.rotationLocked.get() != false ? this.lockedRotation.get().floatValue() : ((float)this.tick + partialTicks) * this.rotationSpeed.get().floatValue();
                Entity entity = this.entity;
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    int eyeOffset = (int)(this.entity.m_20192_() * scale);
                    if (this.trackMouse.get().booleanValue()) {
                        GuiEntityRenderer.renderEntityInInventoryFollowsMouse(render, xPos, yPos, scale, xPos - (float)mouseX, yPos - (float)mouseY - (float)eyeOffset, living);
                    } else {
                        GuiEntityRenderer.renderEntityInInventoryWithRotation(render, xPos, yPos, scale, rotation, living);
                    }
                } else {
                    Quaternion quaternionf = Vector3f.f_122227_.m_122270_((float)Math.PI);
                    Quaternion quaternionf1 = Vector3f.f_122225_.m_122240_(rotation);
                    quaternionf.m_80148_(quaternionf1);
                    GuiEntityRenderer.renderEntityInInventory(render, xPos, yPos, scale, quaternionf, quaternionf1, this.entity);
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LOGGER.error("Failed to render entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LOGGER.error("Entity: " + this.entity, e);
        }
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        ++this.tick;
        super.tick(mouseX, mouseY);
    }

    public static void renderEntityInInventoryFollowsMouse(GuiRender render, double pX, double pY, double pScale, float offsetX, float offsetY, LivingEntity pEntity) {
        float xAngle = (float)Math.atan(offsetX / 40.0f);
        float yAngle = (float)Math.atan(offsetY / 40.0f);
        GuiEntityRenderer.renderEntityInInventoryFollowsAngle(render, pX, pY, pScale, xAngle, yAngle, pEntity);
    }

    public static void renderEntityInInventoryFollowsAngle(GuiRender render, double pX, double pY, double pScale, float angleX, float angleY, LivingEntity pEntity) {
        Quaternion quaternionf = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternionf1 = Vector3f.f_122225_.m_122240_(angleY * 20.0f);
        quaternionf.m_80148_(quaternionf1);
        float f2 = pEntity.f_20883_;
        float f3 = pEntity.m_146908_();
        float f4 = pEntity.m_146909_();
        float f5 = pEntity.f_20886_;
        float f6 = pEntity.f_20885_;
        pEntity.f_20883_ = 180.0f + angleX * 20.0f;
        pEntity.m_146922_(180.0f + angleX * 40.0f);
        pEntity.m_146926_(-angleY * 20.0f);
        pEntity.f_20885_ = pEntity.m_146908_();
        pEntity.f_20886_ = pEntity.m_146908_();
        GuiEntityRenderer.renderEntityInInventory(render, pX, pY, pScale, quaternionf, quaternionf1, (Entity)pEntity);
        pEntity.f_20883_ = f2;
        pEntity.m_146922_(f3);
        pEntity.m_146926_(f4);
        pEntity.f_20886_ = f5;
        pEntity.f_20885_ = f6;
    }

    public static void renderEntityInInventoryWithRotation(GuiRender render, double xPos, double yPos, double scale, double rotation, LivingEntity living) {
        Quaternion quaternionf = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternionf1 = Vector3f.f_122225_.m_122240_((float)rotation);
        quaternionf.m_80148_(quaternionf1);
        float f2 = living.f_20883_;
        float f3 = living.m_146908_();
        float f4 = living.m_146909_();
        float f5 = living.f_20886_;
        float f6 = living.f_20885_;
        living.f_20883_ = 180.0f;
        living.m_146922_(180.0f);
        living.m_146926_(0.0f);
        living.f_20885_ = living.m_146908_();
        living.f_20886_ = living.m_146908_();
        GuiEntityRenderer.renderEntityInInventory(render, xPos, yPos, scale, quaternionf, quaternionf1, (Entity)living);
        living.f_20883_ = f2;
        living.m_146922_(f3);
        living.m_146926_(f4);
        living.f_20886_ = f5;
        living.f_20885_ = f6;
    }

    public static void renderEntityInInventory(GuiRender render, double pX, double pY, double pScale, Quaternion quat, @Nullable Quaternion pCameraOrientation, Entity pEntity) {
        render.pose().m_85836_();
        render.pose().m_85837_(pX, pY, 50.0);
        render.pose().m_166854_(Matrix4f.m_27632_((float)((float)pScale), (float)((float)pScale), (float)((float)(-pScale))));
        render.pose().m_85845_(quat);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        if (pCameraOrientation != null) {
            pCameraOrientation.m_80157_();
            entityrenderdispatcher.m_114412_(pCameraOrientation);
        }
        entityrenderdispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_(pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, render.pose(), (MultiBufferSource)render.buffers(), 0xF000F0));
        render.flush();
        entityrenderdispatcher.m_114468_(true);
        render.pose().m_85849_();
        Lighting.m_84931_();
    }
}

