/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.List;
import java.util.function.Function;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiScrolling;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class GuiInfoPanel
extends GuiElement<GuiInfoPanel>
implements ForegroundRender {
    private int minWidth = 24;
    private int minHeight = 24;
    private int maxWidth = 80;
    private int maxHeight = 120;
    private double expandAnim = 0.0;
    private double animSpeed = 0.1;
    private Material closedIcon = null;
    private int iconWidth;
    private int iconHeight;
    private Borders borders = new Borders(4.0, 4.0, 4.0, 4.0);
    private boolean expanded = false;
    private GuiScrolling scrollElement = null;
    private GuiSlider scrollBar = null;

    public GuiInfoPanel(@NotNull GuiParent<?> parent) {
        super(parent);
        this.jeiExclude();
        this.constrain(GeoParam.WIDTH, Constraint.dynamic(() -> (double)this.minWidth + (double)(this.maxWidth - this.minWidth) * this.expandAnim));
        this.constrain(GeoParam.HEIGHT, Constraint.dynamic(() -> (double)this.minHeight + (double)(this.maxHeight - this.minHeight) * this.expandAnim));
    }

    public GuiInfoPanel setBackground(Function<GuiInfoPanel, GuiElement<?>> backgroundBuilder) {
        return this.setBackground(backgroundBuilder.apply(this));
    }

    public GuiInfoPanel setBackground(GuiElement<?> background) {
        if (background.getParent() != this) {
            throw new IllegalStateException("Background parent must be the parent GuiInfoPanel");
        }
        if (this.scrollElement != null) {
            throw new IllegalStateException("Background must be set before content is added");
        }
        Constraints.bind(background, this);
        return this;
    }

    public GuiInfoPanel setMinSize(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        return this;
    }

    public GuiInfoPanel setMaxSize(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        return this;
    }

    public GuiInfoPanel setIcon(Material closedIcon, int iconWidth, int iconHeight) {
        this.closedIcon = closedIcon;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        return this;
    }

    public GuiInfoPanel setAnimSpeed(double animSpeed) {
        this.animSpeed = animSpeed;
        return this;
    }

    public GuiInfoPanel setBorders(Borders borders) {
        this.borders = borders;
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver() && button == 0) {
            this.expanded = !this.expanded;
            return true;
        }
        return false;
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        if (this.expanded && this.expandAnim < 1.0) {
            this.expandAnim = Math.min(this.expandAnim + this.animSpeed, 1.0);
        }
        if (!this.expanded && this.expandAnim > 0.0) {
            this.expandAnim = Math.max(this.expandAnim - this.animSpeed, 0.0);
        }
    }

    protected void initScrollElement() {
        if (this.scrollElement != null) {
            return;
        }
        this.scrollElement = (GuiScrolling)new GuiScrolling(this).setEnabled(() -> this.expanded && this.expandAnim == 1.0);
        Constraints.bind(this.scrollElement, this, this.borders);
        this.scrollElement.getContentElement().constrain(GeoParam.RIGHT, Constraint.match(this.scrollElement.get(GeoParam.RIGHT)));
        this.scrollBar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider(this, Axis.Y).setEnabled(() -> this.expanded && this.expandAnim == 1.0 && this.scrollElement.hiddenSize(Axis.Y) > 0.0)).setSliderState(this.scrollElement.scrollState(Axis.Y)).setScrollableElement(this).constrain(GeoParam.TOP, Constraint.match(this.scrollElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(this.scrollElement.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, Constraint.match(this.scrollElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, Constraint.dynamic(this.borders::right));
        GuiRectangle bar = new GuiRectangle(this.scrollBar.getSlider()).fill(0x30FFFFFF);
        Constraints.bind(bar, this.scrollBar.getSlider());
        ((GuiRectangle)bar.constrain(GeoParam.RIGHT, null)).constrain(GeoParam.WIDTH, Constraint.literal(1.0));
    }

    public GuiScrolling getScrollElement() {
        this.initScrollElement();
        return this.scrollElement;
    }

    public GuiElement<?> getContentElement() {
        return this.getScrollElement().getContentElement();
    }

    public GuiSlider getScrollBar() {
        return this.scrollBar;
    }

    @Override
    public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.expandAnim < 1.0 && this.closedIcon != null) {
            render.texRect(this.closedIcon, this.xCenter() - (double)this.iconWidth / 2.0, this.yCenter() - (double)this.iconHeight / 2.0, this.iconWidth, this.iconHeight, 1.0f, 1.0f, 1.0f, 1.0f - (float)this.expandAnim);
        }
    }

    public static GuiInfoPanel basicInfoPanel(GuiElement<?> parent, Function<GuiInfoPanel, GuiElement<?>> backgroundBuilder, Component title, Component ... textTiles) {
        return GuiInfoPanel.basicInfoPanel(parent, backgroundBuilder, title, List.of(textTiles), Align.LEFT);
    }

    public static GuiInfoPanel basicInfoPanel(GuiElement<?> parent, Function<GuiInfoPanel, GuiElement<?>> backgroundBuilder, Component title, List<Component> textTiles, Align align) {
        GuiInfoPanel panel = new GuiInfoPanel(parent);
        panel.setBackground(backgroundBuilder);
        GuiElement<?> content = panel.getContentElement();
        GuiText titleText = ((GuiText)((GuiText)((GuiText)new GuiText(content, title).constrain(GeoParam.TOP, Constraint.match(content.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(content.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(content.get(GeoParam.RIGHT)))).setWrap(true).autoHeight();
        ConstrainedGeometry last = null;
        for (Component comp : textTiles) {
            last = ((GuiText)((GuiText)((GuiText)new GuiText(content, comp).setAlignment(align).constrain(GeoParam.TOP, last == null ? Constraint.relative(titleText.get(GeoParam.BOTTOM), 4.0) : Constraint.relative(last.get(GeoParam.BOTTOM), 1.0))).constrain(GeoParam.LEFT, Constraint.match(content.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(content.get(GeoParam.RIGHT)))).setWrap(true).autoHeight();
        }
        return panel;
    }
}

