/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class CooldownTracker {
    private static final CooldownTracker clientInstance = new CooldownTracker();
    private static final CooldownTracker serverInstance = new CooldownTracker();
    private final Map<UUID, Long> lastUltimineTime = new HashMap<UUID, Long>();
    private static long ultimineCooldownClient;

    public static long getLastUltimineTime(Player player) {
        CooldownTracker instance = player.f_19853_.f_46443_ ? clientInstance : serverInstance;
        return instance.lastUltimineTime.getOrDefault(player.m_20148_(), 0L);
    }

    public static void setLastUltimineTime(Player player, long when) {
        CooldownTracker instance = player.f_19853_.f_46443_ ? clientInstance : serverInstance;
        instance.lastUltimineTime.put(player.m_20148_(), when);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            new SyncUltimineTimePacket(when, SyncUltimineTimePacket.TimeType.LAST_USED).sendTo(sp);
        }
    }

    public static float getCooldownRemaining(Player player) {
        long coolDown = CooldownTracker.getUltimineCooldown(player);
        if (coolDown == 0L) {
            return 1.0f;
        }
        long tickDelta = (System.currentTimeMillis() - CooldownTracker.getLastUltimineTime(player)) / 50L;
        return Mth.m_14036_((float)((float)tickDelta / (float)coolDown), (float)0.0f, (float)1.0f);
    }

    public static boolean isOnCooldown(Player player) {
        long coolDown = CooldownTracker.getUltimineCooldown(player);
        if (coolDown == 0L) {
            return false;
        }
        long coolDownMs = coolDown * 50L;
        return coolDownMs > 0L && System.currentTimeMillis() - CooldownTracker.getLastUltimineTime(player) < coolDownMs;
    }

    private static long getUltimineCooldown(Player player) {
        long l;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            l = FTBUltimineServerConfig.getUltimineCooldown(sp);
        } else {
            l = ultimineCooldownClient;
        }
        return l;
    }

    public static void setClientCooldownTime(long cooldown) {
        ultimineCooldownClient = cooldown;
    }
}

