/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.feature.stalled_chunk_load_detection;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import org.embeddedt.modernfix.ModernFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkCache.class}, priority=1100)
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private Thread f_8330_;
    @Shadow
    @Final
    public ServerLevel f_8329_;
    @Shadow
    @Final
    private ServerChunkCache.MainThreadExecutor f_8332_;
    private final boolean debugDeadServerAccess = Boolean.getBoolean("modernfix.debugBadChunkloading");

    @Shadow
    protected abstract CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_8456_(int var1, int var2, ChunkStatus var3, boolean var4);

    @Inject(method={"getChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void bailIfServerDead(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<ChunkAccess> cir) {
        CompletableFuture future;
        if (!this.f_8329_.m_7654_().m_130010_() && !this.f_8330_.isAlive()) {
            ModernFix.LOGGER.fatal("A mod is accessing chunks from a stopped server (this will also cause memory leaks)");
            if (this.debugDeadServerAccess) {
                new Exception().printStackTrace();
            }
            Holder plains = this.f_8329_.m_5962_().m_175515_(Registry.f_122885_).m_206081_(Biomes.f_48202_);
            cir.setReturnValue((Object)new EmptyLevelChunk((Level)this.f_8329_, new ChunkPos(chunkX, chunkZ), plains));
        } else if (Thread.currentThread() != this.f_8330_ && !(future = CompletableFuture.supplyAsync(() -> this.m_8456_(chunkX, chunkZ, requiredStatus, false), (Executor)this.f_8332_).join()).isDone()) {
            Either resultingChunk = null;
            try {
                resultingChunk = (Either)future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            if (resultingChunk != null && resultingChunk.left().isPresent()) {
                cir.setReturnValue((Object)((ChunkAccess)resultingChunk.left().get()));
                return;
            }
            if (this.debugDeadServerAccess) {
                ModernFix.LOGGER.warn("Async loading of a chunk was requested, this might not be desirable", (Throwable)new Exception());
            }
            try {
                resultingChunk = (Either)future.get(10L, TimeUnit.SECONDS);
                if (resultingChunk.left().isPresent()) {
                    cir.setReturnValue((Object)((ChunkAccess)resultingChunk.left().get()));
                    return;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ModernFix.LOGGER.error("Async chunk load took way too long, this needs to be reported to the appropriate mod.", (Throwable)e);
            }
        }
    }
}

