/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.general;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IWailaConfig;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

@WailaPlugin(value="jadeaddons")
public class GeneralPlugin
implements IWailaPlugin {
    public static final String ID = "jadeaddons";
    public static final ResourceLocation EQUIPMENT_REQUIREMENT = new ResourceLocation("jadeaddons", "equipment_requirement");
    static IWailaClientRegistration client;
    public static BiPredicate<Player, TagKey<Item>> EQUIPMENT_CHECK_PREDICATE;
    public TagKey<Item> requirementTag;

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(IWailaClientRegistration registration) {
        client = registration;
        registration.addConfig(EQUIPMENT_REQUIREMENT, "", ResourceLocation::m_135830_);
        registration.addConfigListener(EQUIPMENT_REQUIREMENT, id -> this.refreshTag((ResourceLocation)id, $ -> {
            this.requirementTag = $;
        }));
        registration.addRayTraceCallback(10000, this::override);
        if (ModList.get().isLoaded("curios")) {
            EQUIPMENT_CHECK_PREDICATE = EQUIPMENT_CHECK_PREDICATE.or((player, tag) -> CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{SlotTypePreset.HEAD.getIdentifier()}).stream().filter(result -> !result.slotContext().cosmetic()).anyMatch(result -> result.stack().m_204117_(tag)));
        }
        MinecraftForge.EVENT_BUS.addListener(this::tagsUpdated);
    }

    private void refreshTags() {
        this.refreshTag(EQUIPMENT_REQUIREMENT, $ -> {
            this.requirementTag = $;
        });
    }

    private void refreshTag(ResourceLocation id, Consumer<TagKey<Item>> setter) {
        String s = IWailaConfig.get().getPlugin().getString(id);
        if (s.isBlank()) {
            setter.accept(null);
        } else {
            setter.accept((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(s)));
        }
    }

    private void tagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            this.refreshTags();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Accessor<?> override(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (accessor != null) {
            Player player = accessor.getPlayer();
            if (this.requirementTag != null && !EQUIPMENT_CHECK_PREDICATE.test(player, this.requirementTag)) {
                return null;
            }
        }
        return accessor;
    }

    static {
        EQUIPMENT_CHECK_PREDICATE = (player, tag) -> player.m_21205_().m_204117_(tag) || player.m_21206_().m_204117_(tag) || player.m_6844_(EquipmentSlot.HEAD).m_204117_(tag);
    }
}

