/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sunekaer.toolkit.jobs.ServerTickJobRunner;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;

public class DrainFluidCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"drain").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"area-size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(ctx -> DrainFluidCommand.drainFluids((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_().m_20183_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"area-size"), false)))).then(Commands.m_82129_((String)"location", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"area-size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(ctx -> DrainFluidCommand.drainFluids((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"location"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"area-size"), true))));
    }

    private static int drainFluids(CommandSourceStack source, BlockPos location, int areaSize, boolean shift) {
        BlockState state;
        ServerLevel level = source.m_81372_();
        BlockPos pos = location;
        if (shift) {
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.m_121945_(dir);
                FluidState currentState = level.m_6425_(offset);
                if (currentState.m_76178_()) continue;
                pos = offset;
                break;
            }
        }
        if ((state = level.m_8055_(pos)).m_60795_()) {
            source.m_81352_((Component)Component.m_237113_((String)"Go away"));
            return 1;
        }
        if (state.m_60819_().m_76178_()) {
            source.m_81352_((Component)Component.m_237113_((String)"No fluid found"));
            return 1;
        }
        FluidState fluidState = state.m_60819_();
        ArrayDeque<BlockPos> scanQueue = new ArrayDeque<BlockPos>();
        scanQueue.add(pos);
        int maxSize = Math.min(areaSize, 300);
        BoundingBox box = new BoundingBox(pos).m_191961_(maxSize);
        HashSet<BlockPos> locationsToRemove = new HashSet<BlockPos>();
        while (!scanQueue.isEmpty()) {
            BlockPos currentPos = (BlockPos)scanQueue.pop();
            locationsToRemove.add(currentPos);
            for (Direction dir : Direction.values()) {
                BlockPos offset = currentPos.m_121945_(dir);
                FluidState currentState = level.m_6425_(offset);
                if (currentState.m_76178_() || !fluidState.m_76152_().m_6212_(currentState.m_76152_()) || locationsToRemove.contains(offset) || !box.m_71051_((Vec3i)offset)) continue;
                scanQueue.add(offset);
                locationsToRemove.add(offset);
            }
        }
        ServerTickJobRunner.get().add(() -> {
            for (BlockPos blockPos : locationsToRemove) {
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                level.m_6289_(blockPos, Blocks.f_50016_);
            }
        });
        return 0;
    }
}

