/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.utils;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ChunkRangeIterator
implements Iterator<BlockPos> {
    private final Level level;
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;
    private int currentX;
    private int currentY;
    private int currentZ;
    private final boolean reverseY;

    public ChunkRangeIterator(Level level, ChunkPos startPos, int size) {
        this(level, startPos, size, false);
    }

    public ChunkRangeIterator(Level level, ChunkPos startPos, int size, boolean reverseY) {
        this.level = level;
        int rangeSize = Math.max(0, size / 2);
        this.minX = startPos.f_45578_ - rangeSize << 4;
        this.minZ = startPos.f_45579_ - rangeSize << 4;
        this.maxX = (startPos.f_45578_ + rangeSize << 4) + 16;
        this.maxZ = (startPos.f_45579_ + rangeSize << 4) + 16;
        this.currentX = this.minX;
        this.currentZ = this.minZ;
        this.reverseY = reverseY;
        this.currentY = reverseY ? level.m_151558_() : level.m_141937_();
    }

    @Override
    public boolean hasNext() {
        return (this.reverseY ? this.currentY > this.level.m_141937_() : this.currentY < this.level.m_151558_()) && this.currentZ < this.maxZ && this.currentX < this.maxX;
    }

    @Override
    public BlockPos next() {
        BlockPos pos = new BlockPos(this.currentX, this.currentY, this.currentZ);
        ++this.currentX;
        if (this.currentX >= this.maxX) {
            this.currentX = this.minX;
            ++this.currentZ;
            if (this.currentZ >= this.maxZ) {
                this.currentZ = this.minZ;
                this.currentY = this.reverseY ? --this.currentY : ++this.currentY;
            }
        }
        return pos;
    }
}

