/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.block.DockBlock;
import tfar.dankstorage.container.DockMenu;
import tfar.dankstorage.init.ModBlockEntityTypes;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.DankInventory;

public class DockBlockEntity
extends BlockEntity
implements Nameable,
MenuProvider {
    public CompoundTag settings;
    public int numPlayersUsing = 0;
    protected Component customName;
    protected boolean originalName;
    public static final DankInventory DUMMY = new DankInventory(DankStats.zero, -1);

    public DockBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlockEntityTypes.dank_tile, blockPos, blockState);
    }

    public void setFrequency(int freq) {
        if (this.settings != null) {
            this.settings.m_128405_("dankstorage:id", freq);
        }
    }

    public DankInventory getInventory() {
        if (this.settings != null && this.settings.m_128441_("dankstorage:id")) {
            int id = this.settings.m_128451_("dankstorage:id");
            DankInventory dankInventory = DankStorage.instance.data.getInventory(id);
            if (dankInventory == null) {
                int next = DankStorage.instance.data.getNextID();
                dankInventory = DankStorage.instance.data.getOrCreateInventory(next, DankStats.values()[(Integer)this.m_58900_().m_61143_((Property)DockBlock.TIER)]);
                this.settings.m_128405_("dankstorage:id", next);
            }
            return dankInventory;
        }
        return DUMMY;
    }

    public int getComparatorSignal() {
        return this.getInventory().calcRedstone();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.m_6596_();
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.settings = compound.m_128469_("settings");
        if (compound.m_128425_("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.settings != null) {
            tag.m_128365_("settings", (Tag)this.settings);
        }
        if (this.m_8077_()) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return super.m_5995_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getDefaultName() {
        return Utils.translatable("container.dankstorage.dank_" + this.m_58900_().m_61143_((Property)DockBlock.TIER));
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component text) {
        this.customName = text;
    }

    @Nullable
    public DockMenu createMenu(int syncId, Inventory inventory, Player player) {
        int tier = (Integer)this.m_58900_().m_61143_((Property)DockBlock.TIER);
        DankInventory dankInventory = this.getInventory();
        DankStats type = DankStats.values()[tier];
        if (type != dankInventory.dankStats) {
            if (type.ordinal() < dankInventory.dankStats.ordinal()) {
                Utils.warn(player, type, dankInventory.dankStats);
                return null;
            }
            dankInventory.upgradeTo(type);
        }
        return switch ((Integer)this.m_58900_().m_61143_((Property)DockBlock.TIER)) {
            case 1 -> DockMenu.t1s(syncId, inventory, dankInventory, this);
            case 2 -> DockMenu.t2s(syncId, inventory, dankInventory, this);
            case 3 -> DockMenu.t3s(syncId, inventory, dankInventory, this);
            case 4 -> DockMenu.t4s(syncId, inventory, dankInventory, this);
            case 5 -> DockMenu.t5s(syncId, inventory, dankInventory, this);
            case 6 -> DockMenu.t6s(syncId, inventory, dankInventory, this);
            case 7 -> DockMenu.t7s(syncId, inventory, dankInventory, this);
            default -> null;
        };
    }

    public void giveToPlayer(Player player) {
        ItemStack dankInStack = this.removeDankWithoutItemSpawn();
        if (!player.m_36356_(dankInStack)) {
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), dankInStack);
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    public void removeDankWithItemSpawn() {
        ItemStack dankInStack = this.removeDankWithoutItemSpawn();
        ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), dankInStack);
        this.f_58857_.m_7967_((Entity)entity);
    }

    public ItemStack removeDankWithoutItemSpawn() {
        int tier = (Integer)this.m_58900_().m_61143_((Property)DockBlock.TIER);
        if (tier == 0) {
            throw new RuntimeException("tried to remove a null dank?");
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DockBlock.TIER, (Comparable)Integer.valueOf(0)));
        ItemStack stack = new ItemStack((ItemLike)Utils.getItemFromTier(tier));
        if (this.settings != null) {
            stack.m_41784_().m_128365_("settings", (Tag)this.settings);
        }
        this.settings = null;
        if (this.m_8077_() && this.originalName) {
            stack.m_41714_(this.m_7770_());
        }
        this.setCustomName(null);
        this.originalName = false;
        this.m_6596_();
        return stack;
    }

    public void addDank(ItemStack tank) {
        if (tank.m_41720_() instanceof DankItem) {
            DankInventory dankInventory;
            DankStats stats = ((DankItem)tank.m_41720_()).stats;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
            this.originalName = tank.m_41788_();
            if (this.originalName) {
                this.setCustomName(tank.m_41786_());
            }
            CompoundTag iSettings = Utils.getSettings(tank);
            tank.m_41774_(1);
            if (iSettings != null && iSettings.m_128441_("dankstorage:id")) {
                this.settings = iSettings;
                dankInventory = DankStorage.instance.data.getInventory(iSettings.m_128451_("dankstorage:id"));
            } else {
                this.settings = new CompoundTag();
                int newId = DankStorage.instance.data.getNextID();
                dankInventory = DankStorage.instance.data.getOrCreateInventory(newId, stats);
                this.settings.m_128405_("dankstorage:id", newId);
            }
            if (stats != dankInventory.dankStats) {
                dankInventory.upgradeTo(stats);
            }
            this.m_6596_();
        }
    }

    public void upgradeTo(DankStats stats) {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)DockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
        DankInventory dankInventory = this.getInventory();
        dankInventory.upgradeTo(stats);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? LazyOptional.of(this::getInventory).cast() : super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    public void reviveCaps() {
        super.reviveCaps();
    }
}

