/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.block.entity.duct;

import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.IGridType;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.block.entity.duct.DuctBlockEntity;
import cofh.thermal.dynamics.grid.fluid.FluidGrid;
import cofh.thermal.dynamics.grid.fluid.FluidGridNode;
import cofh.thermal.dynamics.init.TDynBlockEntities;
import cofh.thermal.dynamics.init.TDynGrids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidDuctBlockEntity
extends DuctBlockEntity<FluidGrid, FluidGridNode> {
    public FluidDuctBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public FluidDuctBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TDynBlockEntities.FLUID_DUCT_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected boolean canConnectToBlock(Direction dir) {
        if (!this.connections[dir.ordinal()].allowBlockConnection()) {
            return false;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (tile == null || GridHelper.getGridHost(tile) != null) {
            return false;
        }
        return tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.m_122424_()).isPresent();
    }

    @Override
    public IGridType<FluidGrid> getGridType() {
        return (IGridType)TDynGrids.FLUID_GRID.get();
    }

    @Override
    public boolean canConnectTo(IDuct<?, ?> other, Direction dir) {
        Object obj;
        if (!this.f_58857_.f_46443_ && (obj = other.getGrid()) instanceof FluidGrid) {
            FluidGrid otherGrid = (FluidGrid)obj;
            FluidStack myFluid = ((FluidGrid)this.getGrid()).getFluid();
            FluidStack otherFluid = otherGrid.getFluid();
            if (!(myFluid.isEmpty() || otherFluid.isEmpty() || FluidHelper.fluidsEqual((FluidStack)myFluid, (FluidStack)otherFluid))) {
                return false;
            }
        }
        return super.canConnectTo(other, dir);
    }
}

