/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.Serializable;
import net.bdew.lib.JSResLoc$;
import net.bdew.lib.JSSinglePair$;
import net.bdew.lib.misc.Taggable$;
import net.bdew.lib.recipes.FluidStackIngredient;
import net.bdew.lib.recipes.GenIngredient;
import net.bdew.lib.recipes.GenIngredient$;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class FluidStackIngredient$
implements Serializable {
    public static final FluidStackIngredient$ MODULE$ = new FluidStackIngredient$();
    private static final FluidStackIngredient EMPTY = new FluidStackIngredient(GenIngredient$.MODULE$.empty(Taggable$.MODULE$.TagableFluid()), 0);

    public FluidStackIngredient EMPTY() {
        return EMPTY;
    }

    public Set<GenIngredient<Fluid>> singleFluid(JsonObject js) {
        Option<Tuple2<String, JsonElement>> option;
        Option<Tuple2<String, JsonElement>> option2;
        JsonObject jsonObject = js;
        if (jsonObject != null && !(option2 = JSSinglePair$.MODULE$.unapply(jsonObject)).isEmpty()) {
            Option<ResourceLocation> option3;
            String string = (String)((Tuple2)option2.get())._1();
            JsonElement jsonElement = (JsonElement)((Tuple2)option2.get())._2();
            if ("fluid".equals(string) && jsonElement != null && !(option3 = JSResLoc$.MODULE$.unapply(jsonElement)).isEmpty()) {
                ResourceLocation key = (ResourceLocation)option3.get();
                if (!ForgeRegistries.FLUIDS.containsKey(key)) {
                    throw new JsonSyntaxException("Fluid not found - " + key);
                }
                return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GenIngredient[]{GenIngredient$.MODULE$.of(ForgeRegistries.FLUIDS.getValue(key), Taggable$.MODULE$.TagableFluid())}));
            }
        }
        if (jsonObject != null && !(option = JSSinglePair$.MODULE$.unapply(jsonObject)).isEmpty()) {
            Option<ResourceLocation> option4;
            String string = (String)((Tuple2)option.get())._1();
            JsonElement jsonElement = (JsonElement)((Tuple2)option.get())._2();
            if ("fluidTag".equals(string) && jsonElement != null && !(option4 = JSResLoc$.MODULE$.unapply(jsonElement)).isEmpty()) {
                ResourceLocation key = (ResourceLocation)option4.get();
                return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GenIngredient[]{GenIngredient$.MODULE$.of(FluidTags.create((ResourceLocation)key), Taggable$.MODULE$.TagableFluid())}));
            }
        }
        throw new JsonSyntaxException("Invalid fluid ingredient: " + js.toString());
    }

    public FluidStackIngredient fromJson(JsonObject js) {
        GenIngredient<Fluid> genIngredient;
        if (js.has("fluid")) {
            ResourceLocation key = new ResourceLocation(js.get("fluid").getAsString());
            if (!ForgeRegistries.FLUIDS.containsKey(key)) {
                throw new JsonSyntaxException("Fluid not found - " + key);
            }
            genIngredient = GenIngredient$.MODULE$.of(ForgeRegistries.FLUIDS.getValue(key), Taggable$.MODULE$.TagableFluid());
        } else if (js.has("fluidTag")) {
            ResourceLocation key = new ResourceLocation(js.get("fluidTag").getAsString());
            genIngredient = GenIngredient$.MODULE$.of(FluidTags.create((ResourceLocation)key), Taggable$.MODULE$.TagableFluid());
        } else {
            throw new JsonSyntaxException("Invalid fluid ingredient: " + js.toString());
        }
        GenIngredient<Fluid> fluid = genIngredient;
        int amount = js.has("amount") ? js.get("amount").getAsInt() : 1000;
        return new FluidStackIngredient(fluid, amount);
    }

    public FluidStackIngredient fromPacket(FriendlyByteBuf pkt) {
        GenIngredient<Fluid> fluid = GenIngredient$.MODULE$.fromPacket(pkt, Taggable$.MODULE$.TagableFluid());
        int amount = pkt.readInt();
        return new FluidStackIngredient(fluid, amount);
    }

    public FluidStackIngredient apply(GenIngredient<Fluid> fluid, int amount) {
        return new FluidStackIngredient(fluid, amount);
    }

    public Option<Tuple2<GenIngredient<Fluid>, Object>> unapply(FluidStackIngredient x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.fluid(), (Object)BoxesRunTime.boxToInteger((int)x$0.amount())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FluidStackIngredient$.class);
    }

    private FluidStackIngredient$() {
    }
}

