/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.blocks;

import java.util.List;
import me.codexadrian.spirit.SpiritConfig;
import me.codexadrian.spirit.blocks.blockentity.PedestalBlockEntity;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystalPedestalBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0)});

    public CrystalPedestalBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (interactionHand != InteractionHand.OFF_HAND) {
            ItemStack itemStack = player.m_21205_();
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof PedestalBlockEntity) {
                PedestalBlockEntity crystalPedestal = (PedestalBlockEntity)blockEntity;
                ItemStack pedestalItem = crystalPedestal.m_8020_(0);
                if (crystalPedestal.m_7983_()) {
                    if (itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) || itemStack.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get()) || itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
                        crystalPedestal.m_6836_(0, itemStack.m_41777_());
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41764_(0);
                        }
                        crystalPedestal.m_6596_();
                        level.m_7260_(blockPos, blockState, blockState, 3);
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (itemStack.m_41619_()) {
                        ItemStack soulCrystal = crystalPedestal.m_7407_(0, 3);
                        player.m_150109_().m_150079_(soulCrystal);
                        return InteractionResult.SUCCESS;
                    }
                    if (SoulUtils.getSoulsInCrystal(itemStack) > 0) {
                        if (pedestalItem.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get()) && (itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) || itemStack.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get()) || itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get()))) {
                            if (SoulUtils.canCrystalAcceptSoul(pedestalItem, null)) {
                                int deviateSoulCount = Math.min(SpiritConfig.getCrudeSoulCrystalCap() - SoulUtils.getSoulsInCrystal(pedestalItem), SoulUtils.getSoulsInCrystal(itemStack));
                                this.combineSoulCrystals(level, blockPos, itemStack, pedestalItem, deviateSoulCount, null);
                                crystalPedestal.m_6596_();
                                level.m_7260_(blockPos, blockState, blockState, 3);
                                return InteractionResult.SUCCESS;
                            }
                        } else if (pedestalItem.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
                            int maxSouls = SoulUtils.getMaxSouls(pedestalItem, level);
                            int soulsInCrystal = SoulUtils.getSoulsInCrystal(pedestalItem);
                            if (SoulUtils.doCrystalTypesMatch(pedestalItem, itemStack) && soulsInCrystal < maxSouls || !pedestalItem.m_41782_()) {
                                int deviateSoulCount = Math.min(maxSouls - soulsInCrystal, SoulUtils.getSoulsInCrystal(itemStack));
                                this.combineSoulCrystals(level, blockPos, itemStack, pedestalItem, deviateSoulCount, SoulUtils.getSoulCrystalType(itemStack));
                                crystalPedestal.m_6596_();
                                level.m_7260_(blockPos, blockState, blockState, 3);
                                return InteractionResult.SUCCESS;
                            }
                        } else if (pedestalItem.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get()) && itemStack.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && (pedestalItem.m_41783_() == null || !pedestalItem.m_41783_().m_128441_("EntityType"))) {
                            this.combineSoulCrystals(level, blockPos, itemStack, pedestalItem, 1, SoulUtils.getSoulCrystalType(itemStack));
                            crystalPedestal.m_6596_();
                            level.m_7260_(blockPos, blockState, blockState, 3);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    private void combineSoulCrystals(@NotNull Level level, @NotNull BlockPos blockPos, ItemStack itemStack, ItemStack pedestalItem, int deviateSoulCount, @Nullable String mobType) {
        SoulUtils.deviateSoulCount(pedestalItem, deviateSoulCount, level, mobType);
        SoulUtils.deviateSoulCount(itemStack, -deviateSoulCount, level, mobType);
        if (!level.m_5776_()) {
            ServerLevel sLevel = (ServerLevel)level;
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.4, (double)blockPos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return CrystalPedestalBlock.m_152132_(blockEntityType, SpiritBlocks.PEDESTAL_ENTITY.get(), PedestalBlockEntity::tick);
    }

    public boolean m_222958_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new PedestalBlockEntity(blockPos, blockState);
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState blockState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootContext.Builder builder) {
        List drops = super.m_7381_(blockState, builder);
        BlockEntity blockE = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockE instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlock = (PedestalBlockEntity)blockE;
            drops.add(pedestalBlock.m_8020_(0));
        }
        return drops;
    }

    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }
}

