/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.blocks;

import java.util.ArrayList;
import java.util.List;
import me.codexadrian.spirit.blocks.blockentity.SoulPedestalBlockEntity;
import me.codexadrian.spirit.recipe.PedestalRecipe;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.registry.SpiritMisc;
import me.codexadrian.spirit.utils.RecipeUtils;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulPedestalBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.m_49796_((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0)});

    public SoulPedestalBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (interactionHand != InteractionHand.OFF_HAND) {
            ItemStack stack = player.m_21120_(interactionHand);
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof SoulPedestalBlockEntity) {
                SoulPedestalBlockEntity soulPedestal = (SoulPedestalBlockEntity)blockEntity;
                if (stack.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) || stack.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get()) || stack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
                    if (soulPedestal.type == null && SoulUtils.getSoulsInCrystal(stack) > 0) {
                        if (stack.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) || stack.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
                            soulPedestal.setType((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)SoulUtils.getSoulCrystalType(stack))));
                        } else {
                            soulPedestal.setType(SpiritMisc.SOUL_ENTITY.get());
                        }
                        SoulUtils.deviateSoulCount(stack, -1, level, null);
                        level.m_7260_(blockPos, blockState, blockState, 3);
                        return InteractionResult.m_19078_((boolean)level.m_5776_());
                    }
                    if (soulPedestal.type != null && SoulUtils.canCrystalAcceptSoul(stack, level, soulPedestal.type)) {
                        SoulUtils.deviateSoulCount(stack, 1, level, Registry.f_122826_.m_7981_(soulPedestal.type).toString());
                        level.m_7260_(blockPos, blockState, blockState, 3);
                        soulPedestal.setType(null);
                        return InteractionResult.m_19078_((boolean)level.m_5776_());
                    }
                } else if (soulPedestal.type != null) {
                    if (stack.m_150930_(SpiritItems.SOUL_STEEL_WAND.get())) {
                        soulPedestal.setType(SpiritMisc.SOUL_ENTITY.get());
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.25, (double)blockPos.m_123343_() + 0.5, 10, 0.0, 0.0, 0.0, 0.05);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.25, (double)blockPos.m_123343_() + 0.5, 10, 0.0, 0.0, 0.0, 0.05);
                        }
                        return InteractionResult.m_19078_((boolean)level.m_5776_());
                    }
                    List<PedestalRecipe> recipes = PedestalRecipe.getRecipesForEntity(soulPedestal.type, stack, level.m_7465_());
                    if (!recipes.isEmpty()) {
                        for (PedestalRecipe recipe : recipes) {
                            if (!RecipeUtils.validatePedestals(blockPos, level, new ArrayList<Ingredient>(recipe.ingredients()), false)) continue;
                            soulPedestal.setRecipe(recipe);
                            if (recipe.consumesActivator() && !stack.m_41619_()) {
                                stack.m_41774_(1);
                            }
                            return InteractionResult.m_19078_((boolean)level.m_5776_());
                        }
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return SoulPedestalBlock.m_152132_(blockEntityType, SpiritBlocks.SOUL_PEDESTAL_ENTITY.get(), SoulPedestalBlockEntity::tick);
    }

    public boolean m_222958_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new SoulPedestalBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }
}

