/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.rei.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import me.codexadrian.spirit.compat.jei.multiblock.SoulEngulfingRecipeWrapper;
import me.codexadrian.spirit.compat.rei.categories.SoulEngulfingCategory;
import me.codexadrian.spirit.recipe.SoulEngulfingRecipe;
import me.codexadrian.spirit.recipe.SoulfireMultiblock;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class SoulEngulfingDisplay
implements Display {
    private final SoulEngulfingRecipeWrapper wrapper;
    private final EntryIngredient input;
    private final EntryIngredient catalyst;
    private final EntryIngredient output;

    public SoulEngulfingDisplay(SoulEngulfingRecipe recipe) {
        this(new SoulEngulfingRecipeWrapper(recipe));
    }

    public SoulEngulfingDisplay(SoulEngulfingRecipeWrapper wrapper) {
        this.wrapper = wrapper;
        SoulEngulfingRecipe recipe = wrapper.getRecipe();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Collection<SoulfireMultiblock.StrippedBlockPredicate> blocks = recipe.input().multiblock().keys().values();
        List holderSets = blocks.stream().flatMap(predicate -> {
            if (predicate.blocks().isPresent()) {
                return predicate.blocks().get().m_203614_();
            }
            return Stream.of(new Holder[0]);
        }).toList();
        for (Holder holderSet : holderSets) {
            items.add(((Block)holderSet.m_203334_()).m_5456_().m_7968_());
        }
        this.input = EntryIngredients.ofIngredient((Ingredient)recipe.input().item());
        this.catalyst = EntryIngredients.ofIngredient((Ingredient)Ingredient.m_43921_(items.stream()));
        this.output = EntryIngredients.of((ItemStack)recipe.m_8043_());
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(this.input, this.catalyst);
    }

    public List<EntryIngredient> getRequiredEntries() {
        return List.of(this.input);
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(this.output);
    }

    public SoulEngulfingRecipeWrapper getWrapper() {
        return this.wrapper;
    }

    public EntryIngredient getInput() {
        return this.input;
    }

    public EntryIngredient getCatalyst() {
        return this.catalyst;
    }

    public EntryIngredient getOutput() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return SoulEngulfingCategory.RECIPE;
    }
}

