/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.function.Function;
import me.codexadrian.spirit.Spirit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodecRecipeSerializer<R extends Recipe<?>>
implements RecipeSerializer<R> {
    private static final Gson GSON = new Gson();
    private final RecipeType<R> recipeType;
    private final Function<ResourceLocation, Codec<R>> codecInitializer;

    public CodecRecipeSerializer(RecipeType<R> recipeType, Function<ResourceLocation, Codec<R>> codecInitializer) {
        this.recipeType = recipeType;
        this.codecInitializer = codecInitializer;
    }

    @NotNull
    public R m_6729_(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        return (R)((Recipe)this.codecInitializer.apply(id).parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, s -> Spirit.LOGGER.error("Could not parse {}", (Object)id)));
    }

    @Nullable
    public R m_8005_(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        Optional result = this.codecInitializer.apply(id).parse((DynamicOps)JsonOps.COMPRESSED, (Object)((JsonElement)GSON.fromJson(buffer.m_130277_(), JsonArray.class))).result();
        return (R)((Recipe)result.orElse(null));
    }

    public void m_6178_(@NotNull FriendlyByteBuf buffer, @NotNull R recipe) {
        this.codecInitializer.apply(recipe.m_6423_()).encodeStart((DynamicOps)JsonOps.COMPRESSED, recipe).result().ifPresent(element -> buffer.m_130070_(element.toString()));
    }

    public RecipeType<R> type() {
        return this.recipeType;
    }
}

