/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.mixin;

import java.util.Optional;
import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.Spirit;
import me.codexadrian.spirit.SpiritConfig;
import me.codexadrian.spirit.blocks.blockentity.PedestalBlockEntity;
import me.codexadrian.spirit.data.MobTrait;
import me.codexadrian.spirit.data.MobTraitData;
import me.codexadrian.spirit.data.traits.DamageTrait;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements Corrupted {
    private static final EntityDataAccessor<Boolean> CORRUPTED = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineCorrupted(CallbackInfo ci) {
        this.f_19804_.m_135372_(CORRUPTED, (Object)false);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCorrupted(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128471_("Corrupted")) {
            this.setCorrupted();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void saveCorrupted(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.isCorrupted()) {
            compoundTag.m_128379_("Corrupted", true);
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void onDeath(DamageSource source, CallbackInfo ci) {
        LivingEntity victim = (LivingEntity)this;
        Corrupted corrupt = (Corrupted)victim;
        if (!victim.f_19853_.f_46443_) {
            Entity entity = source.m_7639_();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                entity = projectile.m_37282_();
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!victim.m_6095_().m_204039_(Spirit.COLLECT_BLACKLISTED_TAG) && victim.m_6072_() && (SpiritConfig.isCollectFromCorrupt() || !corrupt.isCorrupted())) {
                    PedestalBlockEntity pedestal;
                    BlockEntity blockEntity;
                    boolean pedestalHasCrystal = false;
                    ItemStack crystal = ItemStack.f_41583_;
                    int radius = SpiritConfig.getSoulPedestalRadius();
                    AABB entityArea = victim.m_20191_().m_82377_((double)radius, 2.0, (double)radius);
                    Optional<BlockPos> pedestalPos = BlockPos.m_121921_((AABB)entityArea).filter(pos -> this.f_19853_.m_8055_(pos).m_60713_(SpiritBlocks.CRYSTAL_PEDESTAL.get())).map(BlockPos::m_7949_).findFirst();
                    if (pedestalPos.isPresent() && (blockEntity = this.f_19853_.m_7702_(pedestalPos.get())) instanceof PedestalBlockEntity && !(pedestal = (PedestalBlockEntity)blockEntity).m_7983_() && SoulUtils.canCrystalAcceptSoul(pedestal.m_8020_(0), victim)) {
                        crystal = pedestal.m_8020_(0);
                        pedestalHasCrystal = true;
                        pedestal.m_6596_();
                        this.f_19853_.m_7260_(pedestalPos.get(), pedestal.m_58900_(), pedestal.m_58900_(), 3);
                    }
                    if (crystal.m_41619_() && !SoulUtils.canCrystalAcceptSoul(crystal, victim)) {
                        crystal = SoulUtils.findCrystal(player, victim, false, false, true);
                    }
                    if (!crystal.m_41619_()) {
                        if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL.get())) {
                            SoulUtils.handleSoulCrystal(crystal, player, victim);
                        } else if (crystal.m_150930_(SpiritItems.CRUDE_SOUL_CRYSTAL.get())) {
                            SoulUtils.handleCrudeSoulCrystal(crystal, player, victim);
                        } else if (crystal.m_150930_(SpiritItems.SOUL_CRYSTAL_SHARD.get())) {
                            SoulUtils.handleMobCrystal(crystal, player, victim);
                        }
                        if (pedestalPos.isPresent() && pedestalHasCrystal) {
                            ServerLevel sLevel = (ServerLevel)player.f_19853_;
                            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pedestalPos.get().m_123341_() + 0.5, (double)pedestalPos.get().m_123342_() + 0.5, (double)pedestalPos.get().m_123343_() + 0.5, 15, 0.5, 1.0, 0.5, 0.0);
                            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pedestalPos.get().m_123341_() + 0.5, (double)pedestalPos.get().m_123342_() + 0.5, (double)pedestalPos.get().m_123343_() + 0.5, 15, 0.5, 1.0, 0.5, 0.0);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isCorrupted() {
        return (Boolean)this.f_19804_.m_135370_(CORRUPTED);
    }

    @Override
    public void setCorrupted() {
        this.f_19804_.m_135381_(CORRUPTED, (Object)true);
    }

    @Inject(method={"getAttributeValue"}, at={@At(value="RETURN")}, cancellable=true)
    public void getMobTraitDamage(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        Optional<MobTraitData> entityEffect;
        String soulCrystalType;
        ItemStack soulCrystal;
        Player player;
        LivingEntityMixin livingEntityMixin;
        if (attribute == Attributes.f_22281_ && (livingEntityMixin = this) instanceof Player && (player = (Player)livingEntityMixin).m_150109_() != null && (player.m_21205_().m_150930_(SpiritItems.SOUL_STEEL_AXE.get()) || player.m_21205_().m_150930_(SpiritItems.SOUL_STEEL_BLADE.get())) && player.m_21205_().m_41784_().m_128471_("Charged") && !(soulCrystal = SoulUtils.findCrystal(player, null, true, true, false)).m_41619_() && (soulCrystalType = SoulUtils.getSoulCrystalType(soulCrystal)) != null && SoulUtils.getSoulsInCrystal(soulCrystal) > 0 && (entityEffect = MobTraitData.getEffectForEntity((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)soulCrystalType)), player.m_9236_().m_7465_())).isPresent()) {
            int damage = 0;
            for (MobTrait<?> trait : entityEffect.get().traits()) {
                if (!(trait instanceof DamageTrait)) continue;
                DamageTrait damageTrait = (DamageTrait)trait;
                damage = (int)((float)damage + damageTrait.additionalDamage());
            }
            cir.setReturnValue((Object)(cir.getReturnValueD() + (double)damage));
        }
    }
}

