/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.codexadrian.spirit.EngulfableItem;
import me.codexadrian.spirit.data.SyncedData;
import me.codexadrian.spirit.recipe.SoulfireMultiblock;
import me.codexadrian.spirit.registry.SpiritMisc;
import me.codexadrian.spirit.utils.CodecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public record SoulEngulfingRecipe(ResourceLocation id, SoulEngulfingInput input, int duration, boolean breaksBlocks, Item output, int outputAmount) implements SyncedData
{
    public static Codec<SoulEngulfingRecipe> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)SoulEngulfingInput.CODEC.fieldOf("input").forGetter(SoulEngulfingRecipe::input), (App)Codec.INT.fieldOf("duration").orElse((Object)0).forGetter(SoulEngulfingRecipe::duration), (App)Codec.BOOL.fieldOf("destroysStructure").orElse((Object)true).forGetter(SoulEngulfingRecipe::breaksBlocks), (App)Registry.f_122827_.m_194605_().fieldOf("outputItem").forGetter(SoulEngulfingRecipe::output), (App)Codec.INT.fieldOf("outputAmount").orElse((Object)1).forGetter(SoulEngulfingRecipe::outputAmount)).apply((Applicative)instance, SoulEngulfingRecipe::new));
    }

    @Override
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.output, this.outputAmount);
    }

    public ResourceLocation m_6423_() {
        return this.id();
    }

    public RecipeSerializer<?> m_7707_() {
        return SpiritMisc.SOUL_ENGULFING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return SpiritMisc.SOUL_ENGULFING_RECIPE.get();
    }

    public boolean validateRecipe(BlockPos blockPos, ItemEntity itemE, ServerLevel level) {
        SoulfireMultiblock multiblock = this.input().multiblock();
        if (itemE instanceof EngulfableItem) {
            EngulfableItem engulfableItem = (EngulfableItem)itemE;
            if (!engulfableItem.isEngulfed() && this.duration() > 0) {
                engulfableItem.setMaxEngulfTime(this.duration());
            } else if (engulfableItem.isEngulfed() || this.duration() == 0) {
                if (!multiblock.validateMultiblock(blockPos, level, false)) {
                    engulfableItem.resetEngulfing();
                    if (!engulfableItem.isRecipeOutput()) {
                        itemE.m_20331_(false);
                    }
                    return false;
                }
                if (engulfableItem.isFullyEngulfed() && multiblock.validateMultiblock(blockPos, level, this.breaksBlocks())) {
                    itemE.m_20331_(true);
                    ItemEntity output = new ItemEntity(itemE.f_19853_, itemE.m_20185_(), itemE.m_20186_(), itemE.m_20189_(), this.m_8043_());
                    output.m_20331_(true);
                    itemE.f_19853_.m_7967_((Entity)output);
                    if (output instanceof EngulfableItem) {
                        EngulfableItem outputEngulf = (EngulfableItem)output;
                        outputEngulf.setRecipeOutput();
                    }
                    itemE.m_32055_().m_41774_(1);
                    engulfableItem.resetEngulfing();
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 40, 1.0, 2.0, 1.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    public static List<SoulEngulfingRecipe> getRecipesForStack(ItemStack stack, RecipeManager manager) {
        return manager.m_44013_(SpiritMisc.SOUL_ENGULFING_RECIPE.get()).stream().filter(recipe -> recipe.input.item().test(stack)).toList();
    }

    public record SoulEngulfingInput(Ingredient item, SoulfireMultiblock multiblock) {
        public static final Codec<SoulEngulfingInput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.INGREDIENT_CODEC.fieldOf("ingredient").forGetter(SoulEngulfingInput::item), (App)SoulfireMultiblock.CODEC.fieldOf("multiblock").orElse((Object)SoulfireMultiblock.DEFAULT_RECIPE).forGetter(SoulEngulfingInput::multiblock)).apply((Applicative)instance, SoulEngulfingInput::new));
    }
}

