/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.registry;

import java.util.ArrayList;
import java.util.function.Supplier;
import me.codexadrian.spirit.Spirit;
import me.codexadrian.spirit.blocks.CrystalPedestalBlock;
import me.codexadrian.spirit.blocks.PedestalBlock;
import me.codexadrian.spirit.blocks.SoulCageBlock;
import me.codexadrian.spirit.blocks.SoulPedestalBlock;
import me.codexadrian.spirit.blocks.blockentity.PedestalBlockEntity;
import me.codexadrian.spirit.blocks.blockentity.SoulCageBlockEntity;
import me.codexadrian.spirit.blocks.blockentity.SoulPedestalBlockEntity;
import me.codexadrian.spirit.items.ChippedBlockItem;
import me.codexadrian.spirit.platform.fabric.Services;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class SpiritBlocks {
    public static final ArrayList<Supplier<Block>> SOUL_GLASS_BLOCKS = new ArrayList();
    public static final Supplier<Block> SOUL_CAGE = SpiritBlocks.registerBlockWithItem("soul_cage", () -> new SoulCageBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).m_60999_()));
    public static final Supplier<BlockEntityType<SoulCageBlockEntity>> SOUL_CAGE_ENTITY = Services.REGISTRY.registerBlockEntity("soul_cage", () -> Services.REGISTRY.createBlockEntityType(SoulCageBlockEntity::new, SOUL_CAGE.get()));
    public static final Supplier<Block> SOUL_PEDESTAL = SpiritBlocks.registerBlockWithItem("soul_pedestal", () -> new SoulPedestalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).m_60999_()));
    public static final Supplier<Block> CRYSTAL_PEDESTAL = SpiritBlocks.registerBlockWithItem("crystal_pedestal", () -> new CrystalPedestalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).m_60999_()));
    public static final Supplier<BlockEntityType<SoulPedestalBlockEntity>> SOUL_PEDESTAL_ENTITY = Services.REGISTRY.registerBlockEntity("soul_pedestal", () -> Services.REGISTRY.createBlockEntityType(SoulPedestalBlockEntity::new, SOUL_PEDESTAL.get()));
    public static final Supplier<Block> PEDESTAL = SpiritBlocks.registerBlockWithItem("pedestal", () -> new PedestalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).m_60999_()));
    public static final Supplier<BlockEntityType<PedestalBlockEntity>> PEDESTAL_ENTITY = Services.REGISTRY.registerBlockEntity("pedestal", () -> Services.REGISTRY.createBlockEntityType(PedestalBlockEntity::new, PEDESTAL.get(), CRYSTAL_PEDESTAL.get()));
    public static final Supplier<Block> SOUL_GLASS = SpiritBlocks.registerBlockWithItem("soul_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final Supplier<Block> SOUL_SLATE = SpiritBlocks.registerBlockWithItem("soul_slate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_)));
    public static final Supplier<Block> SOUL_STEEL_BLOCK = SpiritBlocks.registerBlockWithItem("soul_steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)), new Item.Properties().m_41491_(Spirit.SPIRIT).m_41497_(Rarity.RARE));
    public static final Supplier<Block> SOUL_POWDER_BLOCK = SpiritBlocks.registerBlockWithItem("soul_powder_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50135_)), new Item.Properties().m_41491_(Spirit.SPIRIT));
    public static final Supplier<Block> COMPRESSED_SOUL_POWDER_BLOCK = SpiritBlocks.registerBlockWithItem("compressed_soul_powder_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50135_)), new Item.Properties().m_41491_(Spirit.SPIRIT));
    public static final Supplier<Block> COMPRESSED_SOUL_SAND = SpiritBlocks.registerBlockWithItem("compressed_soul_sand", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50135_)), new Item.Properties().m_41491_(Spirit.SPIRIT));
    public static final Supplier<Block> BROKEN_SPAWNER = SpiritBlocks.registerBlockWithItem("broken_spawner", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).m_60999_()));

    private static Supplier<Block> registerBlockWithItem(String name, Supplier<Block> block, Item.Properties properties) {
        Supplier<Block> newBlock = Services.REGISTRY.registerBlock(name, block);
        Services.REGISTRY.registerItem(name, () -> new BlockItem((Block)newBlock.get(), properties));
        return newBlock;
    }

    private static Supplier<Block> registerBlockWithItem(String name, Supplier<Block> block) {
        return SpiritBlocks.registerBlockWithItem(name, block, new Item.Properties().m_41491_(Spirit.SPIRIT));
    }

    private static void registerChippedVariants(String name, Supplier<Block> block, int blocks) {
        for (int i = 1; i <= blocks; ++i) {
            Supplier<Block> ctmBlock = Services.REGISTRY.registerBlock(name + "_" + i, block);
            Services.REGISTRY.registerItem(name + "_" + i, () -> new ChippedBlockItem((Block)ctmBlock.get(), Services.PLATFORM.isModLoaded("chipped") ? new Item.Properties().m_41491_(Spirit.SPIRIT) : new Item.Properties()));
            SOUL_GLASS_BLOCKS.add(ctmBlock);
        }
    }

    public static void registerAll() {
        SpiritBlocks.registerChippedVariants("soul_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)), 13);
    }
}

