/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.utils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.codexadrian.spirit.data.MobTrait;
import me.codexadrian.spirit.data.MobTraitData;
import me.codexadrian.spirit.data.ToolType;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.ClientUtils;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ToolUtils {
    @NotNull
    public static InteractionResultHolder<ItemStack> handleToolDrawing(Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        ItemStack crystal = SoulUtils.findCrystal(player, null, true);
        if (player.m_150110_().f_35937_ || !crystal.m_41619_() && SoulUtils.getSoulsInCrystal(crystal) > 0) {
            player.m_6672_(interactionHand);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public static InteractionResult handleOnHitBlock(InteractionResult result, ToolType type, Player player, ItemStack tool, Level level, BlockPos pos) {
        Optional<MobTraitData> entityEffect;
        ItemStack soulCrystal;
        if (result == InteractionResult.CONSUME && (soulCrystal = SoulUtils.findCrystal(player, null, true, true, false)).m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && SoulUtils.getSoulsInCrystal(soulCrystal) > 0 && tool.m_41784_().m_128471_("Charged") && (entityEffect = MobTraitData.getEffectForEntity((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)Objects.requireNonNull(SoulUtils.getSoulCrystalType(soulCrystal)))), level.m_7465_())).isPresent()) {
            for (MobTrait<?> trait : entityEffect.get().traits()) {
                trait.onHitBlock(type, (Entity)player, level.m_8055_(pos), level, pos);
            }
            SoulUtils.deviateSoulCount(soulCrystal, -1, level, null);
            ToolUtils.spawnParticles(player);
        }
        return result;
    }

    public static void handleBreakBlock(Player player, ToolType type, ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos) {
        Optional<MobTraitData> entityEffect;
        ItemStack soulCrystal = SoulUtils.findCrystal(player, null, true, true, false);
        if (soulCrystal.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && SoulUtils.getSoulsInCrystal(soulCrystal) > 0 && itemStack.m_41784_().m_128471_("Charged") && (entityEffect = MobTraitData.getEffectForEntity((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)Objects.requireNonNull(SoulUtils.getSoulCrystalType(soulCrystal)))), level.m_7465_())).isPresent()) {
            for (MobTrait<?> trait : entityEffect.get().traits()) {
                trait.onHitBlock(type, (Entity)player, blockState, level, blockPos);
            }
            SoulUtils.deviateSoulCount(soulCrystal, -1, level, null);
            ToolUtils.spawnParticles(player);
        }
    }

    public static void handleOnHitEntity(ItemStack itemStack, ToolType type, LivingEntity victim, Player player) {
        Optional<MobTraitData> entityEffect;
        ItemStack soulCrystal = SoulUtils.findCrystal(player, null, true, true, false);
        if (!soulCrystal.m_41619_() && soulCrystal.m_150930_(SpiritItems.SOUL_CRYSTAL.get()) && SoulUtils.getSoulsInCrystal(soulCrystal) > 0 && itemStack.m_41784_().m_128471_("Charged") && (entityEffect = MobTraitData.getEffectForEntity((EntityType)Registry.f_122826_.m_7745_(ResourceLocation.m_135820_((String)Objects.requireNonNull(SoulUtils.getSoulCrystalType(soulCrystal)))), player.m_9236_().m_7465_())).isPresent()) {
            for (MobTrait<?> trait : entityEffect.get().traits()) {
                trait.onHitEntity(type, (Entity)player, (Entity)victim);
            }
            SoulUtils.deviateSoulCount(soulCrystal, -1, player.f_19853_, null);
            ToolUtils.spawnParticles(player);
        }
    }

    public static void appendEmpoweredText(@NotNull ItemStack itemStack, @NotNull List<Component> list) {
        if (itemStack.m_41784_().m_128471_("Charged")) {
            list.add((Component)Component.m_237110_((String)"spirit.item.soul_steel_tool.empowered", (Object[])new Object[]{Component.m_237117_((String)"key.spirit.toggle").m_130940_(ChatFormatting.RED)}));
        } else {
            list.add((Component)Component.m_237110_((String)"spirit.item.soul_steel_tool.unpowered", (Object[])new Object[]{Component.m_237117_((String)"key.spirit.toggle").m_130940_(ChatFormatting.AQUA)}));
        }
        MutableComponent description = Component.m_237115_((String)"item.spirit.soul_steel_tools.description").m_130940_(ChatFormatting.GRAY);
        MutableComponent soulSteelRepairable = Component.m_237115_((String)"item.spirit.soul_steel_tools.soul_fire_repairable").m_130940_(ChatFormatting.GRAY);
        ClientUtils.shiftTooltip(list, List.of(description, soulSteelRepairable), List.of());
    }

    public static void spawnParticles(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (double i = 0.0; i < 1.0; i += 0.1) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, player.m_20185_() + Math.sin(i * 2.0 * Math.PI), player.m_20186_() + 0.75, player.m_20189_() + Math.cos(i * 2.0 * Math.PI), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

