/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.contraptionControls;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ContraptionControlsRenderer
extends SmartBlockEntityRenderer<ContraptionControlsBlockEntity> {
    private static Random r = new Random();

    public ContraptionControlsRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(ContraptionControlsBlockEntity blockEntity, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = ((Direction)blockState.m_61143_((Property)ContraptionControlsBlock.f_54117_)).m_122424_();
        Vec3 buttonMovementAxis = VecHelper.rotate(new Vec3(0.0, 1.0, -0.325), AngleHelper.horizontalAngle(facing), Direction.Axis.Y);
        Vec3 buttonMovement = buttonMovementAxis.m_82490_((double)(-0.07f + -0.041666668f * blockEntity.button.getValue(pt)));
        Vec3 buttonOffset = buttonMovementAxis.m_82490_((double)0.07f);
        ms.m_85836_();
        ms.m_85837_(buttonMovement.f_82479_, buttonMovement.f_82480_, buttonMovement.f_82481_);
        super.renderSafe(blockEntity, pt, ms, buffer, light, overlay);
        ms.m_85837_(buttonOffset.f_82479_, buttonOffset.f_82480_, buttonOffset.f_82481_);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110451_());
        CachedBufferer.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_BUTTON, blockState, facing).light(light).renderInto(ms, vc);
        ms.m_85849_();
        int i = (int)blockEntity.indicator.getValue(pt) / 45 % 8 + 8;
        CachedBufferer.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_INDICATOR.get(i % 8), blockState, facing).light(light).renderInto(ms, vc);
    }

    public static void renderInContraption(MovementContext ctx, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        float heightCentering;
        float scale;
        Object object = ctx.temporaryData;
        if (!(object instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
            return;
        }
        ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
        if (!AllBlocks.CONTRAPTION_CONTROLS.has(ctx.state)) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        float playerDistance = (float)(ctx.position == null || cameraEntity == null ? 0.0 : ctx.position.m_82557_(cameraEntity.m_146892_()));
        float flicker = r.nextFloat();
        Couple<Integer> couple = DyeHelper.DYE_TABLE.get(efs.targetYEqualsSelection ? DyeColor.WHITE : DyeColor.ORANGE);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4.0f);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float shadowOffset = 0.5f;
        String text = efs.currentShortName;
        String description = efs.currentLongName;
        PoseStack ms = matrices.getViewProjection();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ms.m_85836_();
        msr.translate((Vec3i)ctx.localPos);
        msr.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle((Direction)ctx.state.m_61143_((Property)ContraptionControlsBlock.f_54117_))));
        ms.m_85837_((double)0.4f, 1.0, 0.5);
        msr.rotate(Direction.WEST, AngleHelper.rad(67.5));
        float buttondepth = -0.25f;
        BlockEntity blockEntity = ctx.contraption.presentBlockEntities.get(ctx.localPos);
        if (blockEntity instanceof ContraptionControlsBlockEntity) {
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)blockEntity;
            buttondepth += -0.041666668f * cbe.button.getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)renderWorld));
        }
        if (!text.isBlank() && playerDistance < 100.0f) {
            int actualWidth = fontRenderer.m_92895_(text);
            int width = Math.max(actualWidth, 12);
            scale = 1.0f / (5.0f * ((float)width - 0.5f));
            heightCentering = ((float)width - 8.0f) / 2.0f;
            ms.m_85836_();
            ms.m_85837_(0.0, (double)0.15f, (double)buttondepth);
            ms.m_85841_(scale, -scale, scale);
            ms.m_85837_((double)(Math.max(0, width - actualWidth) / 2), (double)heightCentering, 0.0);
            NixieTubeRenderer.drawInWorldString(ms, buffer, text, flickeringBrightColor);
            ms.m_85837_((double)shadowOffset, (double)shadowOffset, -0.0625);
            NixieTubeRenderer.drawInWorldString(ms, buffer, text, Color.mixColors(darkColor, 0, 0.35f));
            ms.m_85849_();
        }
        if (!description.isBlank() && playerDistance < 20.0f) {
            int actualWidth = fontRenderer.m_92895_(description);
            int width = Math.max(actualWidth, 55);
            scale = 1.0f / (3.0f * ((float)width - 0.5f));
            heightCentering = ((float)width - 8.0f) / 2.0f;
            ms.m_85836_();
            ms.m_85837_((double)-0.0635f, (double)0.06f, (double)buttondepth);
            ms.m_85841_(scale, -scale, scale);
            ms.m_85837_((double)(Math.max(0, width - actualWidth) / 2), (double)heightCentering, 0.0);
            NixieTubeRenderer.drawInWorldString(ms, buffer, description, flickeringBrightColor);
            ms.m_85849_();
        }
        ms.m_85849_();
    }
}

