/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.plough;

import com.simibubi.create.content.contraptions.actors.plough.PloughBlock;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.trains.track.FakeTrackBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PloughMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.m_61143_((Property)PloughBlock.f_54117_)).m_122424_());
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        Level world = context.world;
        if (world.f_46443_) {
            return;
        }
        BlockPos below = pos.m_7495_();
        if (!world.m_46749_(below)) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)pos);
        PloughBlock.PloughFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        BlockHitResult ray = world.m_45547_(new ClipContext(vec, vec.m_82520_(0.0, -1.0, 0.0), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (ray.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        UseOnContext ctx = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, ray);
        new ItemStack((ItemLike)Items.f_42392_).m_41661_(ctx);
    }

    @Override
    protected void throwEntity(MovementContext context, Entity entity) {
        super.throwEntity(context, entity);
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity fbe = (FallingBlockEntity)entity;
        if (!(fbe.m_31980_().m_60734_() instanceof AnvilBlock)) {
            return;
        }
        if (entity.m_20184_().m_82553_() < 0.25) {
            return;
        }
        entity.f_19853_.m_45976_(Player.class, new AABB(entity.m_20183_()).m_82400_(32.0)).forEach(AllAdvancements.ANVIL_PLOUGH::awardTo);
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)PloughBlock.f_54117_)).m_122436_()).m_82490_(0.45);
    }

    @Override
    protected boolean throwsEntities() {
        return true;
    }

    @Override
    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (world.m_8055_(breakingPos.m_7495_()).m_60734_() instanceof FarmBlock) {
            return false;
        }
        if (state.m_60734_() instanceof LiquidBlock) {
            return false;
        }
        if (state.m_60734_() instanceof BubbleColumnBlock) {
            return false;
        }
        if (state.m_60734_() instanceof NetherPortalBlock) {
            return false;
        }
        if (state.m_60734_() instanceof ITrackBlock) {
            return true;
        }
        if (state.m_60734_() instanceof FakeTrackBlock) {
            return false;
        }
        return state.m_60812_((BlockGetter)world, breakingPos).m_83281_();
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        super.onBlockBroken(context, pos, brokenState);
        if (brokenState.m_60734_() == Blocks.f_50125_ && context.world instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)context.world;
            brokenState.m_60724_(new LootContext.Builder(world).m_78972_(LootContextParams.f_81461_, (Object)brokenState).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81455_, (Object)this.getPlayer(context)).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42384_))).forEach(s -> this.dropItem(context, (ItemStack)s));
        }
    }

    @Override
    public void stopMoving(MovementContext context) {
        super.stopMoving(context);
        if (context.temporaryData instanceof PloughBlock.PloughFakePlayer) {
            ((PloughBlock.PloughFakePlayer)((Object)context.temporaryData)).m_146870_();
        }
    }

    private PloughBlock.PloughFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof PloughBlock.PloughFakePlayer) && context.world != null) {
            PloughBlock.PloughFakePlayer player = new PloughBlock.PloughFakePlayer((ServerLevel)context.world);
            player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42392_));
            context.temporaryData = player;
        }
        return (PloughBlock.PloughFakePlayer)((Object)context.temporaryData);
    }
}

