/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.steamWhistle;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WhistleBlock
extends Block
implements IBE<WhistleBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WALL = BooleanProperty.m_61465_((String)"wall");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<WhistleSize> SIZE = EnumProperty.m_61587_((String)"size", WhistleSize.class);

    public WhistleBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false))).m_61124_(SIZE, (Comparable)((Object)WhistleSize.MEDIUM)));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return FluidTankBlock.isTank(pLevel.m_8055_(pPos.m_121945_(WhistleBlock.getAttachedDirection(pState))));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.m_61122_(SIZE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING, POWERED, SIZE, WALL}));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state;
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        Direction face = pContext.m_43719_();
        boolean wall = true;
        if (face.m_122434_() == Direction.Axis.Y) {
            face = pContext.m_8125_().m_122424_();
            wall = false;
        }
        if (!this.m_7898_(state = (BlockState)((BlockState)((BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)face.m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_46753_(clickedPos)))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(wall)), (LevelReader)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (AllBlocks.STEAM_WHISTLE.isIn(heldItem)) {
            WhistleBlock.incrementSize((LevelAccessor)pLevel, pPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void incrementSize(LevelAccessor pLevel, BlockPos pPos) {
        BlockState base = pLevel.m_8055_(pPos);
        if (!base.m_61138_(SIZE)) {
            return;
        }
        WhistleSize size = (WhistleSize)((Object)base.m_61143_(SIZE));
        SoundType soundtype = base.m_60827_();
        BlockPos currentPos = pPos.m_7494_();
        for (int i = 1; i <= 6; ++i) {
            BlockState blockState = pLevel.m_8055_(currentPos);
            float pVolume = (soundtype.m_56773_() + 1.0f) / 2.0f;
            SoundEvent growSound = SoundEvents.f_12218_;
            SoundEvent hitSound = soundtype.m_56778_();
            if (AllBlocks.STEAM_WHISTLE_EXTENSION.has(blockState)) {
                if (blockState.m_61143_(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                    pLevel.m_7731_(currentPos, (BlockState)blockState.m_61124_(WhistleExtenderBlock.SHAPE, (Comparable)((Object)WhistleExtenderBlock.WhistleExtenderShape.DOUBLE)), 3);
                    if (soundtype != null) {
                        float pPitch = (float)Math.pow(2.0, (double)(-(i * 2)) / 12.0);
                        pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                        pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.m_60767_().m_76336_()) {
                    return;
                }
                pLevel.m_7731_(currentPos, (BlockState)AllBlocks.STEAM_WHISTLE_EXTENSION.getDefaultState().m_61124_(SIZE, (Comparable)((Object)size)), 3);
                if (soundtype != null) {
                    float pPitch = (float)Math.pow(2.0, (double)(-(i * 2 - 1)) / 12.0);
                    pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.m_7494_();
        }
    }

    public static void queuePitchUpdate(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)block;
            if (!level.m_183326_().m_183582_(pos, (Object)whistle)) {
                level.m_186460_(pos, (Block)whistle, 1);
            }
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, WhistleBlockEntity::updatePitch);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.m_121945_(WhistleBlock.getAttachedDirection(pState)));
        if (pOldState.m_60734_() != this || pOldState.m_61143_(SIZE) != pState.m_61143_(SIZE)) {
            WhistleBlock.queuePitchUpdate((LevelAccessor)pLevel, pPos);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        IBE.onRemove(pState, pLevel, pPos, pNewState);
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.m_121945_(WhistleBlock.getAttachedDirection(pState)));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_46753_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return WhistleBlock.getAttachedDirection(pState) == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        WhistleSize size = (WhistleSize)((Object)pState.m_61143_(SIZE));
        if (!((Boolean)pState.m_61143_((Property)WALL)).booleanValue()) {
            return size == WhistleSize.SMALL ? AllShapes.WHISTLE_SMALL_FLOOR : (size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_MEDIUM_FLOOR : AllShapes.WHISTLE_LARGE_FLOOR);
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        return (size == WhistleSize.SMALL ? AllShapes.WHISTLE_SMALL_WALL : (size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_MEDIUM_WALL : AllShapes.WHISTLE_LARGE_WALL)).get(direction);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static Direction getAttachedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)WALL) != false ? (Direction)state.m_61143_((Property)FACING) : Direction.DOWN;
    }

    @Override
    public Class<WhistleBlockEntity> getBlockEntityClass() {
        return WhistleBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends WhistleBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.STEAM_WHISTLE.get();
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public static enum WhistleSize implements StringRepresentable
    {
        SMALL,
        MEDIUM,
        LARGE;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

