/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link.controller;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerMenu;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class LinkedControllerScreen
extends AbstractSimiContainerScreen<LinkedControllerMenu> {
    protected AllGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;

    public LinkedControllerScreen(LinkedControllerMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.background = AllGuiTextures.LINKED_CONTROLLER;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(1, 0);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.resetButton = new IconButton(x + this.background.width - 62, y + this.background.height - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((LinkedControllerMenu)this.f_97732_).clearContents();
            ((LinkedControllerMenu)this.f_97732_).sendClearPacket();
        });
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_(this.resetButton);
        this.m_142416_(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width + 4, y + this.background.height - 44, 64, 56));
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + this.background.height + 4;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(ms, x, y, (GuiComponent)this);
        this.f_96547_.m_92889_(ms, this.f_96539_, (float)(x + 15), (float)(y + 4), 5841956);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((LinkedControllerMenu)this.f_97732_).contentHolder).at(x + this.background.width - 4, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    @Override
    protected void m_181908_() {
        if (!((LinkedControllerMenu)this.f_97732_).player.m_21205_().equals((ItemStack)((LinkedControllerMenu)this.f_97732_).contentHolder, false)) {
            ((LinkedControllerMenu)this.f_97732_).player.m_6915_();
        }
        super.m_181908_();
    }

    protected void m_7025_(PoseStack ms, int x, int y) {
        if (!((LinkedControllerMenu)this.f_97732_).m_142621_().m_41619_() || this.f_97734_ == null || this.f_97734_.m_6657_() || this.f_97734_.f_40218_ == ((LinkedControllerMenu)this.f_97732_).playerInventory) {
            super.m_7025_(ms, x, y);
            return;
        }
        this.renderComponentTooltip(ms, this.addToTooltip(new LinkedList<Component>(), this.f_97734_.getSlotIndex()), x, y, this.f_96547_);
    }

    public List<Component> m_96555_(ItemStack stack) {
        List<Component> list = super.m_96555_(stack);
        if (this.f_97734_.f_40218_ == ((LinkedControllerMenu)this.f_97732_).playerInventory) {
            return list;
        }
        return this.f_97734_ != null ? this.addToTooltip(list, this.f_97734_.getSlotIndex()) : list;
    }

    private List<Component> addToTooltip(List<Component> list, int slot) {
        if (slot < 0 || slot >= 12) {
            return list;
        }
        list.add((Component)Lang.translateDirect("linked_controller.frequency_slot_" + (slot % 2 + 1), ControlsUtil.getControls().get(slot / 2).m_90863_().getString()).m_130940_(ChatFormatting.GOLD));
        return list;
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

