/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityRenderHelper {
    public static void renderBlockEntities(Level world, Iterable<BlockEntity> customRenderBEs, PoseStack ms, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer);
    }

    public static void renderBlockEntities(Level world, Iterable<BlockEntity> customRenderBEs, PoseStack ms, MultiBufferSource buffer, float pt) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer, pt);
    }

    public static void renderBlockEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderBEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, renderWorld, customRenderBEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderBlockEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderBEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer, float pt) {
        Iterator<BlockEntity> iterator = customRenderBEs.iterator();
        while (iterator.hasNext()) {
            BlockEntity blockEntity = iterator.next();
            if (Backend.getBackendType() == BackendType.INSTANCING && Backend.isFlywheelWorld((LevelAccessor)renderWorld) && InstancedRenderRegistry.shouldSkipRender((BlockEntity)blockEntity)) continue;
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(blockEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            BlockPos pos = blockEntity.m_58899_();
            ms.m_85836_();
            TransformStack.cast((PoseStack)ms).translate((Vec3i)pos);
            try {
                int worldLight = BlockEntityRenderHelper.getCombinedLight(world, BlockEntityRenderHelper.getLightPos(lightTransform, pos), renderWorld, pos);
                if (renderWorld != null) {
                    blockEntity.m_142339_((Level)renderWorld);
                    renderer.m_6922_(blockEntity, pt, ms, buffer, worldLight, OverlayTexture.f_118083_);
                    blockEntity.m_142339_(world);
                } else {
                    renderer.m_6922_(blockEntity, pt, ms, buffer, worldLight, OverlayTexture.f_118083_);
                }
            }
            catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + RegisteredObjects.getKeyOrThrow(blockEntity.m_58903_()).toString() + " could not be rendered virtually.";
                if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                    Create.LOGGER.error(message, (Throwable)e);
                }
                Create.LOGGER.error(message);
            }
            ms.m_85849_();
        }
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.m_123341_() + 0.5f, (float)contraptionPos.m_123342_() + 0.5f, (float)contraptionPos.m_123343_() + 0.5f, 1.0f);
            lightVec.m_123607_(lightTransform);
            return new BlockPos((double)lightVec.m_123601_(), (double)lightVec.m_123615_(), (double)lightVec.m_123616_());
        }
        return contraptionPos;
    }

    public static int getCombinedLight(Level world, BlockPos worldPos, @Nullable VirtualRenderWorld renderWorld, BlockPos renderWorldPos) {
        int worldLight = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)worldPos);
        if (renderWorld != null) {
            int renderWorldLight = LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)renderWorldPos);
            return SuperByteBuffer.maxLight(worldLight, renderWorldLight);
        }
        return worldLight;
    }
}

