/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.present.IPresentItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlock
extends AbstractPresentBlock {
    private static final Map<Item, IPresentItemBehavior> TRAPPED_PRESENT_INTERACTIONS_REGISTRY = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue((source, stack) -> Optional.empty()));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public TrappedPresentBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void registerBehavior(ItemLike pItem, IPresentItemBehavior pBehavior) {
        TRAPPED_PRESENT_INTERACTIONS_REGISTRY.put(pItem.m_5456_(), pBehavior);
    }

    public static IPresentItemBehavior getPresentBehavior(ItemStack pStack) {
        return TRAPPED_PRESENT_INTERACTIONS_REGISTRY.get(pStack.m_41720_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TrappedPresentBlockTile(pPos, pState);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            if (pLevel.f_46443_) {
                RandomSource random = pLevel.f_46441_;
                double cx = (double)pPos.m_123341_() + 0.5;
                double cy = (double)pPos.m_123342_() + 0.5 + 0.4;
                double cz = (double)pPos.m_123343_() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double speed = random.m_188500_() * 0.15 + 0.015;
                    double py = cy + 0.02 + (random.m_188500_() - 0.5) * 0.3;
                    double dx = random.m_188583_() * 0.01;
                    double dy = speed + random.m_188583_() * 0.01;
                    double dz = random.m_188583_() * 0.01;
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, cx, py, cz, dx, dy, dz);
                }
                ParticleUtil.spawnBreakParticles((VoxelShape)PresentBlock.SHAPE_LID, (BlockPos)pPos, (BlockState)pState, (Level)pLevel);
            }
            return true;
        }
        return super.m_8133_(pState, pLevel, pPos, pId, pParam);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        boolean isPowered = world.m_46753_(pos);
        if (world instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)world;
            if (isPowered && ((Boolean)state.m_61143_((Property)PACKED)).booleanValue() && (blockEntity = world.m_7702_(pos)) instanceof TrappedPresentBlockTile) {
                TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
                tile.detonate(serverLevel, pos);
            }
        }
    }

    @Nullable
    public Item changeItemColor(@Nullable DyeColor color) {
        Supplier<Block> c = ModRegistry.TRAPPED_PRESENTS.get(color);
        if (c != null) {
            return c.get().m_5456_();
        }
        return null;
    }
}

