/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.customgui.BuildCustomGuiScreen;
import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageCustomGuisScreen
extends CellScreen {
    protected Runnable onCloseRunnable;
    protected List<CustomGui> guis = new ArrayList<CustomGui>();
    @Nullable
    protected CustomGui selected;

    public ManageCustomGuisScreen(@NotNull Runnable onClose) {
        super((Component)Components.translatable("fancymenu.custom_guis.manage", new Object[0]));
        for (CustomGui g : CustomGuiHandler.getGuis()) {
            this.guis.add(g.copy());
        }
        this.onCloseRunnable = onClose;
    }

    @Override
    protected void initCells() {
        for (CustomGui gui : this.guis) {
            this.addCell(new CustomGuiCell(gui)).setSelectable(true);
        }
        this.addSpacerCell(20);
    }

    @Override
    protected void m_7856_() {
        this.selected = null;
        super.m_7856_();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (Component)Components.translatable("fancymenu.custom_guis.manage.add", new Object[0]), var1 -> {
            Screen s = Minecraft.m_91087_().f_91080_;
            Minecraft.m_91087_().m_91152_((Screen)new BuildCustomGuiScreen(null, customGui -> {
                if (customGui != null) {
                    this.guis.add((CustomGui)customGui);
                }
                Minecraft.m_91087_().m_91152_(s);
            }));
        });
        this.addRightSideDefaultSpacer();
        this.addRightSideButton(20, (Component)Components.translatable("fancymenu.custom_guis.manage.open", new Object[0]), var1 -> {
            CustomGui selected = this.selected;
            if (selected != null) {
                CustomGuiHandler.CUSTOM_GUI_SCREENS.clear();
                for (CustomGui g : this.guis) {
                    if (g.identifier.replace(" ", "").isEmpty()) continue;
                    CustomGuiHandler.CUSTOM_GUI_SCREENS.put(g.identifier, g);
                }
                CustomGuiHandler.saveChanges();
                Minecraft.m_91087_().m_91152_((Screen)CustomGuiHandler.constructInstance(selected, Minecraft.m_91087_().f_91080_, null));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);
        this.addRightSideButton(20, (Component)Components.translatable("fancymenu.custom_guis.manage.edit", new Object[0]), var1 -> {
            Screen s = Minecraft.m_91087_().f_91080_;
            CustomGui selected = this.selected;
            if (selected != null) {
                Minecraft.m_91087_().m_91152_((Screen)new BuildCustomGuiScreen(selected, customGui -> Minecraft.m_91087_().m_91152_(s)));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);
        this.addRightSideButton(20, (Component)Components.translatable("fancymenu.custom_guis.manage.remove", new Object[0]), var1 -> {
            Screen s = Minecraft.m_91087_().f_91080_;
            CustomGui selected = this.selected;
            if (selected != null) {
                Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.warning(remove -> {
                    if (remove.booleanValue()) {
                        this.guis.remove(selected);
                    }
                    Minecraft.m_91087_().m_91152_(s);
                }, LocalizationUtils.splitLocalizedLines("fancymenu.custom_guis.manage.remove.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partial) {
        this.selected = this.getSelectedGui();
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    @Override
    protected void onCancel() {
        this.onCloseRunnable.run();
    }

    @Override
    protected void onDone() {
        CustomGuiHandler.CUSTOM_GUI_SCREENS.clear();
        for (CustomGui g : this.guis) {
            if (g.identifier.replace(" ", "").isEmpty()) continue;
            CustomGuiHandler.CUSTOM_GUI_SCREENS.put(g.identifier, g);
        }
        CustomGuiHandler.saveChanges();
        this.onCloseRunnable.run();
    }

    @Nullable
    protected CustomGui getSelectedGui() {
        CellScreen.RenderCell cell = this.getSelectedCell();
        if (cell instanceof CustomGuiCell) {
            CustomGuiCell c = (CustomGuiCell)cell;
            return c.gui;
        }
        return null;
    }

    public class CustomGuiCell
    extends CellScreen.LabelCell {
        protected CustomGui gui;

        public CustomGuiCell(CustomGui gui) {
            super(ManageCustomGuisScreen.this, (Component)Components.literal(gui.identifier));
            this.gui = gui;
        }
    }
}

