/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.musiccontroller;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.elements.musiccontroller.MusicControllerElement;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMusicManager;
import de.keksuccino.fancymenu.util.WorldUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MusicControllerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ActiveController> CONTROLLERS = new HashMap<String, ActiveController>();
    private static boolean initialized = false;
    private static boolean playMenuMusic = true;
    private static boolean playWorldMusic = true;
    private static boolean worldMusicManuallyStopped = false;
    private static boolean menuMusicManuallyStopped = false;
    private static boolean lastTickScreenOpen = false;

    public static void init() {
        if (!initialized) {
            initialized = true;
            EventHandler.INSTANCE.registerListenersOf(new MusicControllerHandler());
        }
    }

    @EventListener
    public void onClientTickPost(ClientTickEvent.Post e) {
        boolean screenOpen = Minecraft.m_91087_().f_91080_ != null;
        ArrayList<ActiveController> cachedControllers = new ArrayList<ActiveController>(CONTROLLERS.values());
        cachedControllers.forEach(activeController -> {
            if (!activeController.updated) {
                CONTROLLERS.remove(activeController.controller.getInstanceIdentifier());
            }
            activeController.updated = false;
        });
        playMenuMusic = true;
        playWorldMusic = true;
        if (!CONTROLLERS.isEmpty() && screenOpen) {
            CONTROLLERS.values().forEach(activeController -> {
                if (!activeController.controller.playMenuMusic) {
                    playMenuMusic = false;
                }
                if (!activeController.controller.playWorldMusic) {
                    playWorldMusic = false;
                }
            });
            if (!MusicControllerHandler.isWorldLoaded()) {
                if (FancyMenu.getOptions().playVanillaMenuMusic.getValue().booleanValue()) {
                    if (!playMenuMusic && MusicControllerHandler.isMenuMusicPlaying()) {
                        Minecraft.m_91087_().m_91397_().m_120186_();
                        Minecraft.m_91087_().m_91106_().m_120405_();
                        menuMusicManuallyStopped = true;
                    } else if (playMenuMusic && !MusicControllerHandler.isMenuMusicPlaying()) {
                        Minecraft.m_91087_().m_91397_().m_120184_(Minecraft.m_91087_().m_91107_());
                        menuMusicManuallyStopped = false;
                    }
                }
            } else if (!playWorldMusic && !worldMusicManuallyStopped) {
                Minecraft.m_91087_().m_91106_().m_120391_();
                worldMusicManuallyStopped = true;
            } else if (playWorldMusic && worldMusicManuallyStopped) {
                Minecraft.m_91087_().m_91106_().m_120407_();
                worldMusicManuallyStopped = false;
            }
        }
        if (!screenOpen) {
            if (MusicControllerHandler.isWorldLoaded() && lastTickScreenOpen && worldMusicManuallyStopped) {
                Minecraft.m_91087_().m_91106_().m_120407_();
            }
            worldMusicManuallyStopped = false;
        }
        if (CONTROLLERS.isEmpty()) {
            if (menuMusicManuallyStopped) {
                if (!MusicControllerHandler.isMenuMusicPlaying()) {
                    Minecraft.m_91087_().m_91397_().m_120184_(Minecraft.m_91087_().m_91107_());
                }
                menuMusicManuallyStopped = false;
            }
            if (MusicControllerHandler.isWorldLoaded() && worldMusicManuallyStopped) {
                if (Minecraft.m_91087_().f_91080_ != null && !Minecraft.m_91087_().f_91080_.m_7043_() || WorldUtils.isMultiplayer()) {
                    Minecraft.m_91087_().m_91106_().m_120407_();
                }
                worldMusicManuallyStopped = false;
            }
        }
        lastTickScreenOpen = screenOpen;
    }

    public static void notify(@NotNull MusicControllerElement controller) {
        ActiveController activeController = CONTROLLERS.computeIfAbsent(controller.getInstanceIdentifier(), k -> new ActiveController(controller));
        activeController.updated = true;
    }

    public static boolean shouldPlayMenuMusic() {
        return playMenuMusic;
    }

    public static boolean shouldPlayWorldMusic() {
        return playWorldMusic;
    }

    private static boolean isMenuMusicPlaying() {
        return ((IMixinMusicManager)Minecraft.m_91087_().m_91397_()).getCurrentMusic_FancyMenu() != null;
    }

    private static boolean isWorldLoaded() {
        return Minecraft.m_91087_().f_91073_ != null;
    }

    protected static class ActiveController {
        protected MusicControllerElement controller;
        protected boolean updated = false;

        protected ActiveController(@NotNull MusicControllerElement controller) {
            this.controller = controller;
        }
    }
}

