/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsMenuTitleRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsMenuTitleRequirement() {
        super("is_menu_title");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        Screen s;
        if (value != null && (s = Minecraft.m_91087_().f_91080_) != null) {
            ComponentContents cc;
            String key = null;
            Component title = ScreenTitleUtils.getTitleOfScreen(s);
            if (title instanceof MutableComponent && (cc = title.m_214077_()) instanceof TranslatableContents) {
                TranslatableContents t = (TranslatableContents)cc;
                key = t.m_237508_();
            }
            String text = title.getString();
            if (key != null && !I18n.m_118938_((String)value, (Object[])new Object[0]).equals(value)) {
                return key.equals(value);
            }
            return text.equals(value);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.editor.loading_requirements.is_menu_title", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirements.is_menu_title.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.editor.loading_requirement.category.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return I18n.m_118938_((String)"fancymenu.editor.loading_requirements.is_menu_title.value", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "Example Title";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsMenuTitleValueConfigScreen s = new IsMenuTitleValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    public static class IsMenuTitleValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String menuTitleOrKey;
        protected CellScreen.TextInputCell menuTitleOrKeyCell;
        protected EditBoxSuggestions localizationKeySuggestions;

        protected IsMenuTitleValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            this.menuTitleOrKey = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getMenuTitleOrKeyString();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.editor.loading_requirements.is_menu_title.value"));
            this.menuTitleOrKeyCell = this.addTextInputCell(null, true, true).setText(id);
            this.localizationKeySuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.menuTitleOrKeyCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, LocalizationUtils.getLocalizationKeys());
            UIBase.applyDefaultWidgetSkinTo(this.localizationKeySuggestions);
            this.menuTitleOrKeyCell.editBox.m_94151_(s -> this.localizationKeySuggestions.m_93881_());
            this.addSpacerCell(10);
            String key = "[UNKNOWN OR UNIVERSAL LAYOUT]";
            String plain = "[UNKNOWN OR UNIVERSAL LAYOUT]";
            LayoutEditorScreen editor = LayoutEditorScreen.getCurrentInstance();
            if (editor != null && editor.layoutTargetScreen != null) {
                String k = ScreenTitleUtils.getTitleLocalizationKeyOfScreen(editor.layoutTargetScreen);
                if (k != null) {
                    key = k;
                }
                plain = ScreenTitleUtils.getTitleOfScreen(editor.layoutTargetScreen).getString();
            }
            this.addLabelCell((Component)Component.m_237110_((String)"fancymenu.editor.loading_requirements.is_menu_title.value.current_menu_title_key", (Object[])new Object[]{Component.m_237113_((String)key).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)))}).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            this.addLabelCell((Component)Component.m_237110_((String)"fancymenu.editor.loading_requirements.is_menu_title.value.current_menu_title_plain", (Object[])new Object[]{Component.m_237113_((String)plain).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)))}).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            this.addSpacerCell(20);
        }

        @Override
        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partial) {
            super.m_6305_(pose, mouseX, mouseY, partial);
            this.localizationKeySuggestions.m_93900_(pose, mouseX, mouseY);
        }

        @Override
        public boolean m_7933_(int $$0, int $$1, int $$2) {
            if (this.localizationKeySuggestions.m_93888_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_7933_($$0, $$1, $$2);
        }

        public boolean m_6050_(double $$0, double $$1, double $$2) {
            if (this.localizationKeySuggestions.m_93882_($$2)) {
                return true;
            }
            return super.m_6050_($$0, $$1, $$2);
        }

        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (this.localizationKeySuggestions.m_93884_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getMenuTitleOrKeyString();
        }

        @NotNull
        protected String getMenuTitleOrKeyString() {
            if (this.menuTitleOrKeyCell != null) {
                return this.menuTitleOrKeyCell.getText();
            }
            return this.menuTitleOrKey;
        }
    }
}

