/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import com.mojang.blaze3d.platform.GlUtil;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlay;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.customization.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMinecraft;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.PerformanceUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class DebugOverlayBuilder {
    @NotNull
    public static DebugOverlay buildDebugOverlay(@NotNull MenuBar menuBar) {
        DebugOverlay overlay = new DebugOverlay();
        overlay.setLineTextShadow(false);
        int menuBarHeight = (int)((float)menuBar.getHeight() * UIBase.calculateFixedScale(menuBar.getScale()));
        overlay.setTopYOffsetSupplier(() -> menuBarHeight + 10);
        overlay.setBottomYOffsetSupplier(() -> -10);
        Screen current = Minecraft.m_91087_().f_91080_;
        if (current == null) {
            return overlay;
        }
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
        if (layer == null) {
            return overlay;
        }
        DebugOverlayBuilder.addScreenCategory(overlay, current, layer);
        DebugOverlayBuilder.addResourcesCategory(overlay);
        DebugOverlayBuilder.addSystemCategory(overlay);
        overlay.addLine("right_click_elements", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.right_click_elements", new Object[0]));
        return overlay;
    }

    private static void addScreenCategory(@NotNull DebugOverlay overlay, @NotNull Screen currentScreen, @NotNull ScreenCustomizationLayer currentScreenLayer) {
        if (!FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue().booleanValue() && !FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue().booleanValue()) {
            return;
        }
        String currentIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(currentScreen);
        boolean customizationEnabled = ScreenCustomization.isCustomizationEnabledForScreen(currentScreen);
        List<Layout> allLayoutsCurrent = LayoutHandler.getAllLayoutsForScreenIdentifier(currentIdentifier, false);
        List<Layout> allUniversalLayoutsCurrent = LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true);
        ArrayList<Layout> enabledUniversalLayoutsCurrent = new ArrayList<Layout>();
        for (Layout l : currentScreenLayer.activeLayouts) {
            if (!l.isUniversalLayout()) continue;
            enabledUniversalLayoutsCurrent.add(l);
        }
        if (FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue().booleanValue()) {
            overlay.addLine("screen_identifier", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
                MutableComponent c = Components.translatable("fancymenu.overlay.debug.screen_identifier", currentIdentifier);
                if (consumes.isHovered()) {
                    c = c.m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)));
                }
                if (consumes.recentlyClicked()) {
                    c = Components.translatable("fancymenu.overlay.debug.screen_identifier.copied", new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
                }
                return c;
            }).setClickAction(line -> Minecraft.m_91087_().f_91068_.m_90911_(currentIdentifier));
            overlay.addLine("screen_size", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_size", "" + Minecraft.m_91087_().m_91268_().m_85443_(), "" + Minecraft.m_91087_().m_91268_().m_85444_()));
        }
        if (FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue().booleanValue()) {
            overlay.addLine("active_layout_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_active_layout_count", "" + (customizationEnabled ? currentScreenLayer.activeLayouts.size() : 0), "" + (customizationEnabled ? enabledUniversalLayoutsCurrent.size() : 0)));
            overlay.addLine("total_layout_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_total_layout_count", "" + (allLayoutsCurrent.size() + allUniversalLayoutsCurrent.size()), "" + allUniversalLayoutsCurrent.size()));
            overlay.addLine("active_elements_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.screen_active_element_count", "" + (customizationEnabled ? currentScreenLayer.allElements.size() : 0)));
        }
        overlay.addSpacerLine("spacer_after_active_element_count", DebugOverlay.LinePosition.TOP_LEFT, 5);
    }

    private static void addResourcesCategory(@NotNull DebugOverlay overlay) {
        if (!FancyMenu.getOptions().debugOverlayShowResourcesCategory.getValue().booleanValue()) {
            return;
        }
        int animationCount = AnimationHandler.getAnimations().size();
        int totalAnimationFrameCount = 0;
        boolean tooHighAnimationResolution = false;
        for (IAnimationRenderer ani : AnimationHandler.getAnimations()) {
            totalAnimationFrameCount += ani.animationFrames();
            if (ani.getWidth() <= 1920 && ani.getHeight() <= 1080) continue;
            tooHighAnimationResolution = true;
        }
        boolean tooManyAnimationFrames = totalAnimationFrameCount > 500;
        int finalTotalAnimationFrameCount = totalAnimationFrameCount;
        int slideshowCount = SlideshowHandler.getSlideshows().size();
        int totalSlideshowImages = 0;
        for (ExternalTextureSlideshowRenderer slide : SlideshowHandler.getSlideshows()) {
            totalSlideshowImages += slide.getImageCount();
        }
        int finalTotalSlideshowImages = totalSlideshowImages;
        overlay.addLine("total_animations", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.loaded_animations", "" + animationCount, "" + finalTotalAnimationFrameCount));
        if (tooManyAnimationFrames) {
            overlay.addLine("too_many_animation_frames", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.loaded_animations.too_many_frames", new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        if (tooHighAnimationResolution) {
            overlay.addLine("too_high_resolution", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.loaded_animations.resolution_too_high", new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        overlay.addLine("total_slideshows", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.loaded_slideshows", "" + slideshowCount, "" + finalTotalSlideshowImages));
        overlay.addSpacerLine("spacer_after_total_slideshows", DebugOverlay.LinePosition.TOP_LEFT, 5);
    }

    private static void addSystemCategory(@NotNull DebugOverlay overlay) {
        if (!FancyMenu.getOptions().debugOverlayShowSystemCategory.getValue().booleanValue()) {
            return;
        }
        overlay.addLine("frames_per_second", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            int fps = IMixinMinecraft.getFpsFancyMenu();
            MutableComponent fpsComp = Components.literal("" + fps);
            if (fps < 20) {
                fpsComp = fpsComp.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
            }
            if (fps < 10) {
                fpsComp = fpsComp.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
            }
            return Components.translatable("fancymenu.overlay.debug.fps", fpsComp);
        });
        overlay.addLine("ram_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            long percent = (total - free) * 100L / max;
            String ramString = DebugOverlayBuilder.bytesToMb(used) + "/" + DebugOverlayBuilder.bytesToMb(max) + "MB";
            String percentString = percent + "%";
            if (percent >= 60L) {
                percentString = String.valueOf(ChatFormatting.GOLD) + percent + "%" + String.valueOf(ChatFormatting.RESET);
            }
            if (percent >= 80L) {
                percentString = String.valueOf(ChatFormatting.RED) + percent + "%" + String.valueOf(ChatFormatting.RESET);
            }
            return Components.translatable("fancymenu.overlay.debug.memory", ramString, percentString);
        });
        overlay.addLine("cpu_jvm_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            double usage = PerformanceUtils.getJvmCpuUsage();
            if (usage < 0.0) {
                usage = 0.0;
            }
            usage *= 100.0;
            usage = MathUtils.round(usage, 1);
            String usageString = usage + "%";
            if (usage > 50.0) {
                usageString = String.valueOf(ChatFormatting.GOLD) + usage + "%" + String.valueOf(ChatFormatting.RESET);
            }
            if (usage >= 80.0) {
                usageString = String.valueOf(ChatFormatting.RED) + usage + "%" + String.valueOf(ChatFormatting.RESET);
            }
            return Component.m_237110_((String)"fancymenu.overlay.debug.cpu_usage.jvm", (Object[])new Object[]{usageString});
        });
        overlay.addLine("cpu_os_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            double usage = PerformanceUtils.getOsCpuUsage();
            if (usage < 0.0) {
                usage = 0.0;
            }
            usage *= 100.0;
            usage = MathUtils.round(usage, 1);
            String usageString = usage + "%";
            if (usage > 50.0) {
                usageString = String.valueOf(ChatFormatting.GOLD) + usage + "%" + String.valueOf(ChatFormatting.RESET);
            }
            if (usage >= 80.0) {
                usageString = String.valueOf(ChatFormatting.RED) + usage + "%" + String.valueOf(ChatFormatting.RESET);
            }
            return Component.m_237110_((String)"fancymenu.overlay.debug.cpu_usage.os", (Object[])new Object[]{usageString});
        });
        overlay.addLine("cpu_info", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.cpu", GlUtil.m_84819_()));
        overlay.addLine("gpu_info", DebugOverlay.LinePosition.TOP_LEFT, consumes -> Components.translatable("fancymenu.overlay.debug.gpu", GlUtil.m_84820_(), GlUtil.m_84821_()));
        overlay.addSpacerLine("spacer_after_gpu_info", DebugOverlay.LinePosition.TOP_LEFT, 5);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

