/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.audio;

import de.keksuccino.fancymenu.customization.element.elements.audio.AudioElementController;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AudioElementVolumePlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public AudioElementVolumePlaceholder() {
        super("audio_element_vol");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        AudioElementController.AudioElementMeta meta;
        String s = dps.values.get("element_identifier");
        if (s != null && (meta = AudioElementController.getMeta(s)) != null) {
            return "" + meta.volume;
        }
        return "0.0";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("element_identifier");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.audio_element_volume", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.audio_element_volume.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.placeholders.categories.audio", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("element_identifier", "put_identifier_of_audio_element_here");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

