/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.client;

import java.security.KeyPair;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.rocketplatform.client.api.QueryResponse;
import net.rocketplatform.client.api.RocketClient;
import net.rocketplatform.client.api.RocketClientFactory;
import net.rocketplatform.client.api.RocketProperties;
import net.rocketplatform.client.api.RocketSubscriptionResponse;
import net.rocketplatform.client.api.auth.MinecraftKeypairAuth;
import net.rocketplatform.client.api.request.RocketRequest;
import net.rocketplatform.client.api.request.RocketStandaloneRequest;
import net.rocketplatform.client.api.request.RocketSubscription;
import net.rocketplatform.client.generated.AttemptInviteCodeResponse;
import net.rocketplatform.client.generated.CreatePlayerServerWorldResponse;
import net.rocketplatform.client.generated.CustomerPortalAddressResponse;
import net.rocketplatform.client.generated.DeletePlayerServerWorldResponse;
import net.rocketplatform.client.generated.InviteCodesList;
import net.rocketplatform.client.generated.InvitedPlayersList;
import net.rocketplatform.client.generated.IsSupportedVersionResponse;
import net.rocketplatform.client.generated.Modpack;
import net.rocketplatform.client.generated.ModpackAsset;
import net.rocketplatform.client.generated.ModpackConfigAddresses;
import net.rocketplatform.client.generated.ModpackLoadoutPricingTier;
import net.rocketplatform.client.generated.ModpackRegion;
import net.rocketplatform.client.generated.PlayerInviteRequest;
import net.rocketplatform.client.generated.PlayerInviteResponse;
import net.rocketplatform.client.generated.PlayerModpackServer;
import net.rocketplatform.client.generated.PlayerModpackServerCreated;
import net.rocketplatform.client.generated.PlayerModpackServersList;
import net.rocketplatform.client.generated.PurchaseModpackAddressResponse;
import net.rocketplatform.client.generated.StartAllPlayerModpackServersResponse;
import net.rocketplatform.client.generated.StartPlayerModpackServerResponse;
import net.rocketplatform.client.generated.StartWorldUploadResponse;
import net.rocketplatform.client.generated.WorldDownloadResponse;
import net.rocketplatform.client.generated.WorldUploadProgress;
import net.rocketplatform.client.generated.WorldUploadProgressResponse;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketRequests;
import net.rocketplatform.game.client.mod.config.RocketClientModConfig;
import org.jetbrains.annotations.Nullable;

public class RocketClientHandler {
    private final RocketClient client;

    private RocketClientHandler(UUID uuid, ProfileKeyPair keyPair) {
        try {
            if (Boolean.parseBoolean(System.getProperty("fabric.development", "false"))) {
                Thread.sleep(2000L);
            }
            this.client = (RocketClient)RocketClient.builder().url(RocketProperties.GAME_INTERFACE_URL).auth(MinecraftKeypairAuth.builder().profileId(uuid).expiry(keyPair.f_219763_().f_219781_().f_219799_()).signature(Base64.getEncoder().encodeToString(keyPair.f_219763_().f_219781_().f_219801_())).keyPair(new KeyPair(keyPair.f_219763_().f_219781_().f_219800_(), keyPair.f_219762_())).build()).header("tenantId", (String)RocketClientModConfig.CONFIG.tenant.get()).header("userId", uuid.toString()).build(Util.m_183991_()).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Unable to create initial connection to Rocket", e);
        }
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public CompletableFuture<List<ModpackAsset>> getAssets(List<String> assets) {
        return this.executeRequestForList(RocketRequests.ASSETS, Map.of("assets", assets));
    }

    public CompletableFuture<PlayerModpackServersList> getAllPlayerServers() {
        return this.executeRequest(RocketRequests.ALL_PLAYER_SERVERS);
    }

    public CompletableFuture<AttemptInviteCodeResponse> attemptInviteCode(String code) {
        return this.executeRequest(RocketRequests.ATTEMPT_INVITE_CODE, "code", code);
    }

    public CompletableFuture<InvitedPlayersList> getInvitedPlayers(String gameServerId) {
        return this.executeRequest(RocketRequests.LIST_INVITED_PLAYERS, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<InviteCodesList> getInviteCodes(String gameServerId) {
        return this.executeRequest(RocketRequests.LIST_INVITE_CODES, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<Modpack> getModpack(String modpackId) {
        return this.executeRequest(RocketRequests.MODPACK, Map.of("modpackId", modpackId));
    }

    public CompletableFuture<Modpack> getModpackFromForeignId(String foreignModpackId) {
        return this.executeRequest(RocketRequests.MODPACK_FROM_FOREIGN_ID, Map.of("foreignModpackId", foreignModpackId));
    }

    public CompletableFuture<List<ModpackRegion>> getModpackRegions() {
        return this.executeRequestForList(RocketRequests.MODPACK_REGIONS);
    }

    public CompletableFuture<ModpackConfigAddresses> getMenuConfigs(int menuVersion) {
        return this.executeRequest(RocketRequests.MENU_CONFIG, Map.of("clientVersionId", menuVersion));
    }

    public CompletableFuture<PlayerModpackServer> getPlayerServerWorldBackups(String gameServerId) {
        return this.executeRequest(RocketRequests.PLAYER_SERVER_WORLD_BACKUPS, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<PlayerModpackServer> getPlayerServerWorlds(String gameServerId) {
        return this.executeRequest(RocketRequests.PLAYER_SERVER_WORLDS, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<PlayerModpackServer> getPlayerServerInfo(String gameServerId) {
        return this.executeRequest(RocketRequests.PLAYER_SERVER_INFO, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<PlayerModpackServer> getPlayerServerState(String gameServerId) {
        return this.executeRequest(RocketRequests.PLAYER_SERVER_STATE, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<PlayerModpackServer> getPlayerServerVersion(String gameServerId) {
        return this.executeRequest(RocketRequests.PLAYER_SERVER_VERSION, Map.of("gameServerId", gameServerId));
    }

    public CompletableFuture<CreatePlayerServerWorldResponse> createPlayerServerWorld(String gameServerId, String worldName, String modpackId, String versionId) {
        return this.executeRequest(RocketRequests.CREATE_PLAYER_SERVER_WORLD, Map.of("gameServerId", gameServerId, "worldName", worldName, "modpackId", modpackId, "versionId", versionId));
    }

    public CompletableFuture<PurchaseModpackAddressResponse> createPurchaseModpackAddress(String modpackId, String versionId, String loadoutId, String regionId, ModpackLoadoutPricingTier pricingTier, @Nullable String gameServerId) {
        Map<String, ModpackLoadoutPricingTier> args = Map.of("modpackId", modpackId, "versionId", versionId, "loadoutId", loadoutId, "regionId", regionId, "pricingTier", pricingTier);
        if (gameServerId != null) {
            args = new HashMap<String, ModpackLoadoutPricingTier>(args);
            args.put("gameServerId", (ModpackLoadoutPricingTier)gameServerId);
        }
        return this.executeRequest(RocketRequests.PURCHASE_MODPACK_ADDRESS, args);
    }

    public CompletableFuture<DeletePlayerServerWorldResponse> deletePlayerServerWorld(String gameServerId, int worldId, String modpackId, String versionId) {
        return this.executeRequest(RocketRequests.DELETE_PLAYER_SERVER_WORLD, Map.of("gameServerId", gameServerId, "worldId", worldId, "modpackId", modpackId, "versionId", versionId));
    }

    public CompletableFuture<CustomerPortalAddressResponse> getCustomerPortalAddress() {
        return this.executeRequest(RocketRequests.CUSTOMER_PORTAL_ADDRESS, Map.of());
    }

    public CompletableFuture<StartWorldUploadResponse> startWorldUpload(String gameServerId, int worldId) {
        return this.executeRequest(RocketRequests.START_WORLD_UPLOAD, Map.of("gameServerId", gameServerId, "worldId", worldId));
    }

    public CompletableFuture<WorldUploadProgressResponse> updateWorldUploadProgress(String gameServerId, String worldUploadId, WorldUploadProgress progress) {
        return this.executeRequest(RocketRequests.WORLD_UPLOAD_PROGRESS, Map.of("gameServerId", gameServerId, "worldUploadId", worldUploadId, "progress", progress));
    }

    public CompletableFuture<StartAllPlayerModpackServersResponse> startAllPlayerServers(String modpackId, String versionId) {
        return this.executeRequest(RocketRequests.START_ALL_PLAYER_SERVERS, Map.of("modpackId", modpackId, "versionId", versionId));
    }

    public CompletableFuture<StartPlayerModpackServerResponse> startPlayerServer(String gameServerId, String versionId) {
        return this.executeRequest(RocketRequests.START_PLAYER_SERVER, Map.of("gameServerId", gameServerId, "versionId", versionId));
    }

    public CompletableFuture<IsSupportedVersionResponse> checkSupportedVersion(String modpackId, String versionId) {
        return this.executeRequest(RocketRequests.SUPPORTED_VERSION, Map.of("modpackId", modpackId, "versionId", versionId));
    }

    public void listenForInviteRequests(Consumer<PlayerInviteRequest> listener) {
        this.executeSubscription(RocketRequests.PLAYER_INVITE_REQUEST, Map.of()).subscribe(listener);
    }

    public void listenForInviteResponses(Consumer<PlayerInviteResponse> listener) {
        this.executeSubscription(RocketRequests.PLAYER_INVITE_RESPONSE, Map.of()).subscribe(listener);
    }

    public void listenForModpackServerCreated(Consumer<PlayerModpackServerCreated> listener) {
        this.executeSubscription(RocketRequests.PLAYER_MODPACK_SERVER_CREATED, Map.of()).subscribe(listener);
    }

    public void listenForWorldDownload(String gameServerId, int worldId, Consumer<WorldDownloadResponse> listener) {
        this.executeSubscription(RocketRequests.DOWNLOAD_WORLD, Map.of("gameServerId", gameServerId, "worldId", worldId)).subscribe(listener);
    }

    public <T> CompletableFuture<T> executeRequest(RocketStandaloneRequest<T> request) {
        return this.executeRequest(request, null);
    }

    public <T> CompletableFuture<T> executeRequest(RocketStandaloneRequest<T> request, String var1Name, Object var1Value) {
        return this.executeRequest(request, Map.of(var1Name, var1Value));
    }

    public <T> CompletableFuture<T> executeRequest(RocketStandaloneRequest<T> request, @Nullable Map<String, Object> variables) {
        return request.execute(this.client, variables);
    }

    public <T> CompletableFuture<List<T>> executeRequestForList(RocketStandaloneRequest<T> request) {
        return this.executeRequestForList(request, null);
    }

    public <T> CompletableFuture<List<T>> executeRequestForList(RocketStandaloneRequest<T> request, @Nullable Map<String, Object> variables) {
        return request.executeForList(this.client, variables);
    }

    public <T> RocketSubscriptionResponse<T> executeSubscription(RocketSubscription<T> subscription, @Nullable Map<String, Object> variables) {
        return subscription.execute(this.client, variables);
    }

    public CompletableFuture<QueryResponse> executeRequest(RocketRequest request, @Nullable Map<String, Object> variables) {
        return request.executeQuery(this.client, variables);
    }

    public void disconnect() {
        if (!this.client.isConnected()) {
            RocketClientMod.getLogger().warn("Attempted to disconnect Rocket client, but client is not connected");
            return;
        }
        this.client.disconnect();
    }

    public void pause() {
        this.client.pause();
    }

    public void unpause() {
        this.client.unpause();
    }

    public static CompletableFuture<RocketClientHandler> create(UUID uuid, ProfileKeyPair keyPair) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> new RocketClientHandler(uuid, keyPair), Util.m_183991_()).thenCompose(handler -> RocketClientHandler.attemptReconnect(new CompletableFuture<RocketClientHandler>(), handler, 5, 0))).exceptionallyCompose(e -> {
            RocketClientMod.getLogger().error("Failed to connect to Rocket. Attempting to reconnect in 10 seconds", e);
            CompletableFuture future = new CompletableFuture();
            RocketClientFactory.getScheduledThreadPool().schedule(() -> RocketClientHandler.create(uuid, keyPair).whenComplete((value, failure) -> {
                if (failure != null) {
                    future.completeExceptionally((Throwable)failure);
                } else {
                    future.complete(value);
                }
            }), 10L, TimeUnit.SECONDS);
            return future;
        });
    }

    private static CompletableFuture<RocketClientHandler> attemptReconnect(CompletableFuture<RocketClientHandler> future, RocketClientHandler handler, int delay, int tries) {
        RocketClientFactory.getScheduledThreadPool().schedule(() -> {
            RocketClient client = handler.client;
            if (!client.isConnected()) {
                RocketClientHandler.attemptReconnect(future, handler, delay, tries + 1);
                RocketClientMod.getLogger().debug("Failed to reconnect to Rocket, retrying in {} seconds (attempt {})", (Object)delay, (Object)tries);
                return;
            }
            future.complete(handler);
            RocketClientMod.getLogger().debug("Connected to Rocket successfully!");
        }, (long)delay, TimeUnit.SECONDS);
        return future;
    }
}

