/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.ModalPanel;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.ModalCompatibleBaseScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.MultilineStringWidget;
import org.jetbrains.annotations.Nullable;

public class InviteCodeCallback
extends ElementCallback {
    @SerializedName(value="invite_code")
    private String inviteCode;
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public InviteCodeCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        BaseScreen baseScreen;
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        if (screen2 instanceof ScreenWrapper) {
            ScreenWrapper wrapper = (ScreenWrapper)screen2;
            v0 = wrapper.getGui();
        } else {
            v0 = baseScreen = null;
        }
        if (baseScreen == null) {
            RocketClientMod.getLogger().error("Unable to find BaseScreen for InviteCodeCallback");
            return;
        }
        String inviteCode = VariableProcessor.process(this.inviteCode, variableStorage);
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.attemptInviteCode(inviteCode))).whenComplete((response, e) -> {
            if (e != null) {
                this.onError(holder, (Throwable)e);
                return;
            }
            if (!response.getFound().booleanValue() || response.getSentPreviously().booleanValue() || response.getOwner().booleanValue()) {
                MutableComponent content = response.getFound() == false ? Component.m_237115_((String)"rgp_client.gui.callback.invalid_code") : (response.getSentPreviously() != false ? Component.m_237115_((String)"rgp_client.gui.callback.code_attempted_previously") : Component.m_237115_((String)"rgp_client.gui.callback.owner_of_server"));
                ErrorPanel panel = new ErrorPanel((Panel)baseScreen, (Component)content);
                panel.setPosAndSize(baseScreen.width / 2 - 100, baseScreen.height / 2 - 50, 200, 100);
                ((ModalCompatibleBaseScreen)baseScreen).pushModalPanel(panel);
                return;
            }
            if (this.onComplete != null) {
                RenderSystem.m_69879_(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
            }
        });
    }

    private static class ErrorPanel
    extends ModalPanel {
        private final Panel textBoxPanel = new Panel(this){

            public void addWidgets() {
                this.add(textBox);
            }

            public void alignWidgets() {
                textBox.setSize(this.width, this.height);
                this.setScrollY(0.0);
            }
        };
        private final MultilineStringWidget textBox;
        private final Button okay;

        public ErrorPanel(Panel panel, Component content) {
            super(panel);
            this.textBox = new MultilineStringWidget(this.textBoxPanel, content);
            this.okay = new SimpleTextButton(this, (Component)Component.m_237115_((String)"gui.okay"), Icons.INFO){

                public void onClicked(MouseButton button) {
                    this.onOkay(button);
                }
            };
        }

        public void addWidgets() {
            this.add((Widget)this.textBoxPanel);
            this.add((Widget)this.okay);
        }

        public void alignWidgets() {
            this.textBox.setMaxWidth(this.width - 8);
            this.textBoxPanel.setPosAndSize(4, 4, this.width - 8, this.height - 32);
            this.textBoxPanel.addWidgets();
            this.textBoxPanel.alignWidgets();
            this.okay.setPosAndSize((this.width - 90) / 2, this.height - 24, 90, 20);
        }

        public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawContextMenuBackground(graphics, x - 3, y - 3, w + 6, h + 6);
        }

        private void onOkay(MouseButton mb) {
            this.playClickSound();
            ((ModalCompatibleBaseScreen)this.getGui()).popModalPanel();
        }

        public boolean keyPressed(Key key) {
            if (key.esc()) {
                this.onOkay(MouseButton.LEFT);
                return true;
            }
            return super.keyPressed(key);
        }
    }
}

