/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.rocketplatform.client.generated.ModpackAsset;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import net.rocketplatform.game.client.mod.util.JsonUtil;
import net.rocketplatform.game.client.mod.util.Vector2i;

public class ImageTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 32;
    private String icon;
    private Component tooltip;
    @SerializedName(value="hover_border")
    private boolean hoverBorder;
    @SerializedName(value="required_variable")
    private String requiredVariable;

    public ImageTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public ImageTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback, String icon, Component tooltip, boolean hoverBorder, Map<String, Object> options, String requiredDisplayVariable) {
        super(type, id, position, callback);
        this.icon = icon;
        this.tooltip = tooltip;
        this.hoverBorder = hoverBorder;
        this.options = options;
        this.requiredDisplayVariable = requiredDisplayVariable;
    }

    public String getIcon() {
        return this.icon;
    }

    public Component getTooltip() {
        return this.tooltip;
    }

    public String getRequiredVariable() {
        return this.requiredVariable;
    }

    public boolean hasHoverBorder() {
        return this.hoverBorder;
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 32);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 32);
    }

    @Override
    public Widget createElement0(final TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, final VariableStorage variableStorage) {
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        String iconText = this.icon == null ? null : VariableProcessor.process(this.icon, variableStorage);
        final AtomicReference<ImageIcon> iconRef = new AtomicReference<ImageIcon>();
        boolean assetIcon = false;
        if (iconText != null) {
            assetIcon = iconText.startsWith("assets/");
            if (assetIcon) {
                String assetLoc = iconText.substring(7);
                if (GuiUtils.isImageCached(assetLoc)) {
                    iconRef.set(new ImageIcon(GuiUtils.getOrLoadImage(null, assetLoc)));
                } else {
                    ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getAssets(List.of(assetLoc)))).whenComplete((assets, e) -> {
                        if (e != null) {
                            RocketClientMod.getLogger().error("Failed to load asset: {}", (Object)assetLoc, e);
                            return;
                        }
                        if (!assets.isEmpty()) {
                            try {
                                String downloadUrl = ((ModpackAsset)assets.get(0)).getDownloadUrl();
                                iconRef.set((ImageIcon)(downloadUrl.startsWith("http") || downloadUrl.startsWith("file") ? new ImageIcon(GuiUtils.getOrLoadImage(URI.create(downloadUrl), assetLoc)) : Icon.getIcon((ResourceLocation)new ResourceLocation(downloadUrl))));
                            }
                            catch (Exception ex) {
                                RocketClientMod.getLogger().error("Failed to load asset: {}", (Object)assetLoc, (Object)ex);
                            }
                        }
                    });
                }
            } else {
                iconRef.set((ImageIcon)(iconText.startsWith("http") || iconText.startsWith("file") ? new ImageIcon(GuiUtils.getOrLoadImage(URI.create(iconText))) : Icon.getIcon((ResourceLocation)new ResourceLocation(iconText))));
            }
        }
        final boolean finalAssetIcon = assetIcon;
        Widget widget = new Widget(screen.getPanel()){

            public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                Icon iconBorderHover;
                Icon icon = (Icon)iconRef.get();
                Icon iconBorder = icon == null ? null : icon.withBorder(Color4I.BLACK, false);
                Icon icon2 = iconBorderHover = icon == null ? null : icon.withBorder(Color4I.WHITE, false);
                if (ImageTemplate.this.hoverBorder && iconBorder != null) {
                    WidgetType widgetType = this.getWidgetType();
                    GuiHelper.setupDrawing();
                    (widgetType == WidgetType.MOUSE_OVER ? iconBorderHover : iconBorder).draw(graphics, x, y, this.width, this.height);
                    return;
                }
                if (icon != null) {
                    GuiHelper.setupDrawing();
                    icon.draw(graphics, x, y, this.width, this.height);
                } else if (finalAssetIcon) {
                    GuiHelper.setupDrawing();
                    GuiUtils.MISSING_IMAGE_ICON.draw(graphics, x, y, this.width, this.height);
                }
            }

            public void addMouseOverText(TooltipList list) {
                if (ImageTemplate.this.tooltip != null) {
                    Component component = VariableProcessor.processComponent(ImageTemplate.this.tooltip, variableStorage);
                    List<Component> components = JsonUtil.splitComponent(component);
                    for (Component splitComponent : components) {
                        if (splitComponent.getString().isBlank()) continue;
                        list.add(splitComponent);
                    }
                }
                super.addMouseOverText(list);
            }

            public WidgetType getWidgetType() {
                String requiredVariable = ImageTemplate.this.getRequiredVariable();
                if (requiredVariable == null) {
                    return super.getWidgetType();
                }
                if (!GuiUtils.shouldProcess(requiredVariable, screen.getStorage())) {
                    return WidgetType.DISABLED;
                }
                return super.getWidgetType();
            }

            public boolean mousePressed(MouseButton button) {
                if (this.isMouseOver()) {
                    if (this.getWidgetType() != WidgetType.DISABLED) {
                        ImageTemplate.this.runCallbacks(screen);
                    }
                    return true;
                }
                return false;
            }
        };
        widget.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return widget;
    }
}

