/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.Vector2i;

public class TextBoxTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 20;
    @SerializedName(value="character_limit")
    private Integer characterLimit;
    @SerializedName(value="variable_id")
    private String variableId;
    @SerializedName(value="default_text")
    private String defaultText;
    @SerializedName(value="numbers_only")
    private boolean numbersOnly;

    public TextBoxTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 150);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 20);
    }

    @Override
    public Widget createElement0(final TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        final Color4I insideColor = Color4I.rgb((int)-16777216);
        TextBox textBox = new TextBox(screen.getPanel()){

            public void onTextChanged() {
                if (TextBoxTemplate.this.variableId != null) {
                    if (this.getText().isBlank()) {
                        screen.getStorage().remove(TextBoxTemplate.this.variableId);
                        return;
                    }
                    screen.getStorage().store(TextBoxTemplate.this.variableId, this.getText());
                }
            }

            public void drawTextBox(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                Color4I borderColor = Color4I.rgb((int)(this.isFocused() ? -1 : -6250336));
                borderColor.draw(graphics, x - 1, y - 1, w + 2, h + 2);
                insideColor.draw(graphics, x, y, w, h);
            }

            public boolean isValid(String str) {
                if (TextBoxTemplate.this.numbersOnly) {
                    if (str == null) {
                        return false;
                    }
                    if (TextBoxTemplate.this.characterLimit != null && str.length() > TextBoxTemplate.this.characterLimit) {
                        return false;
                    }
                    return str.chars().allMatch(Character::isDigit);
                }
                if (TextBoxTemplate.this.characterLimit != null) {
                    return str != null && str.length() <= TextBoxTemplate.this.characterLimit;
                }
                return super.isValid(str);
            }
        };
        if (this.defaultText != null) {
            textBox.setText(VariableProcessor.process(this.defaultText, variableStorage));
        }
        if (this.characterLimit != null) {
            textBox.charLimit = this.characterLimit;
        }
        if (this.variableId != null && screen.getStorage().contains(this.variableId)) {
            textBox.setText((String)screen.getStorage().retrieve(this.variableId));
        }
        textBox.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return textBox;
    }
}

