/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.rocketplatform.game.client.mod.bridge.BaseScreenBridge;
import net.rocketplatform.game.client.mod.ui.ModalPanel;

public abstract class ModalCompatibleBaseScreen
extends BaseScreen {
    private Widget focusedWidget = null;
    private final Deque<ModalPanel> modalPanels = new ArrayDeque<ModalPanel>();

    public ModalCompatibleBaseScreen() {
        ((BaseScreenBridge)((Object)this)).bridge$drawModalPanels(this::drawModalPanels);
    }

    public void pushModalPanel(ModalPanel modalPanel) {
        this.modalPanels.addFirst(modalPanel);
        modalPanel.refreshWidgets();
        modalPanel.setX(Math.min(modalPanel.getX(), this.width - modalPanel.width - 10));
        modalPanel.setY(Math.min(modalPanel.getY(), this.height - modalPanel.height - 10));
    }

    public ModalPanel popModalPanel() {
        if (this.modalPanels.isEmpty()) {
            return null;
        }
        ModalPanel panel = this.modalPanels.removeFirst();
        panel.onClosed();
        this.focusedWidget = null;
        return panel;
    }

    public void closeModalPanel(ModalPanel panel) {
        block1: {
            if (!this.modalPanels.contains((Object)panel)) break block1;
            while (!this.modalPanels.isEmpty() && this.popModalPanel() != panel) {
            }
        }
    }

    public boolean anyModalPanelOpen() {
        return !this.modalPanels.isEmpty();
    }

    public void onClosed() {
        this.modalPanels.clear();
        super.onClosed();
    }

    public void alignWidgets() {
        super.alignWidgets();
        this.modalPanels.forEach(Panel::refreshWidgets);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
        this.setOffset(true);
        if (this.contextMenu != null) {
            this.contextMenu.updateMouseOver(mouseX, mouseY);
        } else {
            this.modalPanels.forEach(p -> p.updateMouseOver(mouseX, mouseY));
            for (Widget widget : this.widgets) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.setOffset(false);
    }

    private void drawModalPanels(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        if (!this.modalPanels.isEmpty()) {
            boolean r = this.getOnlyRenderWidgetsInside();
            boolean i = this.getOnlyInteractWithWidgetsInside();
            this.setOnlyRenderWidgetsInside(false);
            this.setOnlyInteractWithWidgetsInside(false);
            graphics.m_85836_();
            graphics.m_85837_(0.0, 0.0, 10.0);
            Iterator<ModalPanel> iter = this.modalPanels.descendingIterator();
            while (iter.hasNext()) {
                ModalPanel p = iter.next();
                if (!iter.hasNext()) {
                    graphics.m_85837_(0.0, 0.0, -0.05);
                    Color4I.rgba((int)-1608507360).draw(graphics, 0, 0, this.getScreen().m_85445_(), this.getScreen().m_85446_());
                    graphics.m_85837_(0.0, 0.0, 0.05);
                }
                graphics.m_85837_(0.0, 0.0, (double)p.getExtraZlevel());
                p.draw(graphics, theme, p.getX(), p.getY(), p.width, p.height);
                graphics.m_85837_(0.0, 0.0, 1.0);
            }
            graphics.m_85849_();
            this.setOnlyRenderWidgetsInside(r);
            this.setOnlyRenderWidgetsInside(i);
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.modalPanels.isEmpty()) {
            return super.mousePressed(button);
        }
        if (this.modalPanels.peekFirst().isMouseOver()) {
            return this.modalPanels.peekFirst().mousePressed(button);
        }
        this.popModalPanel();
        return false;
    }

    public boolean keyPressed(Key key) {
        if (this.focusedWidget != null && this.focusedWidget.keyPressed(key)) {
            return true;
        }
        if (!this.modalPanels.isEmpty()) {
            if (key.esc()) {
                this.popModalPanel();
                return true;
            }
            return this.modalPanels.peekFirst().keyPressed(key);
        }
        return super.keyPressed(key);
    }

    public void keyReleased(Key key) {
        if (this.modalPanels.isEmpty()) {
            super.keyReleased(key);
        } else {
            this.modalPanels.peekFirst().keyReleased(key);
        }
    }

    public boolean mouseDoubleClicked(MouseButton button) {
        return this.modalPanels.isEmpty() ? super.mouseDoubleClicked(button) : this.modalPanels.peekFirst().mouseDoubleClicked(button);
    }

    public void mouseReleased(MouseButton button) {
        if (this.modalPanels.isEmpty()) {
            super.mouseReleased(button);
        } else {
            this.modalPanels.peekFirst().mouseReleased(button);
        }
    }

    public boolean mouseScrolled(double scroll) {
        if (this.focusedWidget != null && this.focusedWidget.mouseScrolled(scroll)) {
            return true;
        }
        return this.modalPanels.isEmpty() ? super.mouseScrolled(scroll) : this.modalPanels.peekFirst().mouseScrolled(scroll);
    }

    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.focusedWidget != null && this.focusedWidget.charTyped(c, modifiers)) {
            return true;
        }
        return this.modalPanels.isEmpty() ? super.charTyped(c, modifiers) : this.modalPanels.peekFirst().charTyped(c, modifiers);
    }

    public void addMouseOverText(TooltipList list) {
        if (!this.modalPanels.isEmpty()) {
            this.modalPanels.peekFirst().addMouseOverText(list);
        } else {
            super.addMouseOverText(list);
        }
    }

    public void setFocusedWidget(Widget widget) {
        this.focusedWidget = widget;
    }
}

