/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type.list;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.ui.widget.MultilineStringWidget;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import net.rocketplatform.game.client.mod.util.SingleKeyCache;
import org.jetbrains.annotations.Nullable;

public class ListLayoutList
extends ObjectSelectionList<ListEntry> {
    private final Theme theme;

    public ListLayoutList(Minecraft minecraft, int width, int height, Theme theme) {
        this(minecraft, width, height, 44, height - 64, 36, theme);
    }

    public ListLayoutList(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight, Theme theme) {
        super(minecraft, width, height, top, bottom, itemHeight);
        this.theme = theme;
    }

    public int addEntry(ListEntry entry) {
        return super.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public int m_5759_() {
        return super.m_5759_() + 85;
    }

    public void refreshEntries(List<ListEntry> newEntries) {
        this.m_6702_().clear();
        this.m_6702_().addAll(newEntries);
        ListEntry prevSelected = (ListEntry)this.m_93511_();
        if (prevSelected != null && !newEntries.contains((Object)prevSelected)) {
            this.m_6987_(null);
        } else if (prevSelected != null) {
            ListEntry newSelected = newEntries.stream().filter(e -> e.equals((Object)prevSelected)).findFirst().orElse(null);
            this.m_6987_((AbstractSelectionList.Entry)newSelected);
            if (newSelected != null && newSelected.entry.selectedCallback() != null) {
                CallbackHolder.runCallbacks(prevSelected.screen, newSelected.entry, newSelected.entry.selectedCallback(), newSelected.variableStorage);
            }
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 30;
    }

    public static class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final TemplateScreen screen;
        private final ListLayoutList list;
        private final AbstractListLayoutTemplate.ListEntry entry;
        private long lastClickTime;
        private final List<Widget> widgets = new ArrayList<Widget>();
        private boolean initedOnce;
        private int lastWidth;
        private int lastHeight;
        private int lastLeft;
        private int lastTop;
        private final VariableStorage variableStorage;

        public ListEntry(TemplateScreen screen, ListLayoutList list, AbstractListLayoutTemplate.ListEntry entry, @Nullable VariableStorage variableStorage) {
            this.screen = screen;
            this.list = list;
            this.entry = entry;
            this.variableStorage = variableStorage;
            if (variableStorage != null) {
                variableStorage.inherit(screen.getStorage(), false);
            }
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"Entry");
        }

        public void m_6311_(PoseStack guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.lastWidth != width || this.lastHeight != height || this.lastLeft != left || this.lastTop != top) {
                this.initedOnce = false;
                this.lastWidth = width;
                this.lastHeight = height;
                this.lastLeft = left;
                this.lastTop = top;
            }
            if (!this.initedOnce) {
                this.initedOnce = true;
                this.widgets.clear();
                for (ElementTemplate elementTemplate : this.entry.elements()) {
                    if (!(elementTemplate instanceof WidgetElementTemplate)) continue;
                    WidgetElementTemplate ftbElement = (WidgetElementTemplate)elementTemplate;
                    this.widgets.add((Widget)ftbElement.createElement(this.screen, width, height, left, top, this.variableStorage));
                }
            }
            for (Widget widget : this.widgets) {
                widget.draw(guiGraphics, this.list.theme, widget.posX, widget.posY, width, height);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.list.m_6987_((AbstractSelectionList.Entry)this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                if ((this.entry.requiredDoubleClickVariable() == null || GuiUtils.shouldProcess(this.entry.requiredDoubleClickVariable(), this.variableStorage)) && this.entry.callback() != null) {
                    this.entry.runCallbacks(this.screen);
                }
            } else if (this.entry.selectedCallback() != null) {
                CallbackHolder.runCallbacks(this.screen, this.entry, this.entry.selectedCallback(), this.variableStorage);
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public boolean m_5755_(boolean focused) {
            if (focused && this.entry != null && this.entry.selectedCallback() != null) {
                CallbackHolder.runCallbacks(this.screen, this.entry, this.entry.selectedCallback(), this.variableStorage);
            }
            return false;
        }

        public List<Widget> getWidgets() {
            return this.widgets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ListEntry listEntry = (ListEntry)((Object)o);
            return Objects.equals(this.entry.id(), listEntry.entry.id());
        }

        public int hashCode() {
            return Objects.hashCode(this.entry.id());
        }
    }

    public static class LoadingHeader
    extends ListEntry {
        private static final Component LOADING_LABEL = Component.m_237115_((String)"rgp_client.gui.loading_entries");

        public LoadingHeader(TemplateScreen screen, ListLayoutList list, AbstractListLayoutTemplate.ListEntry entry, @Nullable VariableStorage variableStorage) {
            super(screen, list, entry, variableStorage);
        }

        @Override
        public void m_6311_(PoseStack guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            Minecraft minecraft = Minecraft.m_91087_();
            int i = (minecraft.f_91080_.f_96543_ - minecraft.f_91062_.m_92852_((FormattedText)LOADING_LABEL)) / 2;
            int j = top + (height - 9) / 2;
            minecraft.f_91062_.m_92889_(guiGraphics, LOADING_LABEL, (float)i, (float)j, 0xFFFFFF);
            String s = GuiUtils.getLoadingDots(Util.m_137550_());
            int k = (minecraft.f_91080_.f_96543_ - minecraft.f_91062_.m_92895_(s)) / 2;
            int l = j + 9;
            minecraft.f_91062_.m_92883_(guiGraphics, s, (float)k, (float)l, 0x808080);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return false;
        }

        @Override
        public Component m_142172_() {
            return LOADING_LABEL;
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static class EmptyHeader
    extends ListEntry {
        private final Component emptyEntry;
        private final SingleKeyCache<MultilineStringWidget.CacheKey, MultiLineLabel> cache;

        public EmptyHeader(TemplateScreen screen, Component emptyEntry, ListLayoutList list, AbstractListLayoutTemplate.ListEntry entry, @Nullable VariableStorage variableStorage) {
            super(screen, list, entry, variableStorage);
            this.emptyEntry = emptyEntry;
            this.cache = new SingleKeyCache<MultilineStringWidget.CacheKey, MultiLineLabel>(key -> key.maxRows().isPresent() ? MultiLineLabel.m_94345_((Font)Theme.DEFAULT.getFont(), (FormattedText)key.message(), (int)key.maxWidth(), (int)key.maxRows().getAsInt()) : MultiLineLabel.m_94341_((Font)Theme.DEFAULT.getFont(), (FormattedText)key.message(), (int)key.maxWidth()));
        }

        @Override
        public void m_6311_(PoseStack guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.emptyEntry == null) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            MultiLineLabel multiLineLabel = this.cache.getValue(this.getFreshCacheKey());
            multiLineLabel.m_6514_(guiGraphics, minecraft.f_91080_.f_96543_ / 2, top + (height - 9) / 2, 12, 0xFFFFFF);
        }

        private MultilineStringWidget.CacheKey getFreshCacheKey() {
            return new MultilineStringWidget.CacheKey(this.emptyEntry, 250, OptionalInt.empty());
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return false;
        }

        @Override
        public Component m_142172_() {
            return this.emptyEntry;
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }
}

