/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.FDRecipeTypes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CuttingRecipeCategory
implements IRecipeCategory<CuttingBoardRecipe> {
    public static final int OUTPUT_GRID_X = 76;
    public static final int OUTPUT_GRID_Y = 10;
    private final IDrawable slot;
    private final IDrawable slotChance;
    private final Component title = TextUtils.getTranslation("jei.cutting", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public CuttingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelight", "textures/gui/jei/cutting_board.png");
        this.slot = helper.createDrawable(backgroundImage, 0, 58, 18, 18);
        this.slotChance = helper.createDrawable(backgroundImage, 18, 58, 18, 18);
        this.background = helper.createDrawable(backgroundImage, 0, 0, 117, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.CUTTING_BOARD.get()));
    }

    public RecipeType<CuttingBoardRecipe> getRecipeType() {
        return FDRecipeTypes.CUTTING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CuttingBoardRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 8).addIngredients(recipe.getTool());
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 27).addIngredients((Ingredient)recipe.m_7527_().get(0));
        NonNullList<ChanceResult> recipeOutputs = recipe.getRollableResults();
        int size = recipeOutputs.size();
        int centerX = size > 1 ? 1 : 10;
        int centerY = size > 2 ? 1 : 10;
        for (int i = 0; i < size; ++i) {
            int xOffset = centerX + (i % 2 == 0 ? 0 : 19);
            int yOffset = centerY + i / 2 * 19;
            int index = i;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 76 + xOffset, 10 + yOffset).addItemStack(((ChanceResult)recipeOutputs.get(i)).getStack())).addTooltipCallback((slotView, tooltip) -> {
                ChanceResult output = (ChanceResult)recipeOutputs.get(index);
                float chance = output.getChance();
                if (chance != 1.0f) {
                    tooltip.add(1, TextUtils.getTranslation("jei.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
                }
            });
        }
    }

    public void draw(CuttingBoardRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        NonNullList<ChanceResult> recipeOutputs = recipe.getRollableResults();
        int size = recipe.getResults().size();
        int centerX = size > 1 ? 0 : 9;
        int centerY = size > 2 ? 0 : 9;
        for (int i = 0; i < size; ++i) {
            int xOffset = centerX + (i % 2 == 0 ? 0 : 19);
            int yOffset = centerY + i / 2 * 19;
            if (((ChanceResult)recipeOutputs.get(i)).getChance() != 1.0f) {
                this.slotChance.draw(matrixStack, 76 + xOffset, 10 + yOffset);
                continue;
            }
            this.slot.draw(matrixStack, 76 + xOffset, 10 + yOffset);
        }
    }
}

