/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.mixin;

import com.hidoni.transmog.TransmogUtils;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.config.TooltipDetailLevel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    private static final String[] TRANSLATION_KEYS_TO_REMOVE = new String[]{"item.modifiers.*", "attribute.modifier.*", "item.unbreakable", "item.canBreak", "item.canPlace", "item.durability", "item.nbt_tags", "item.disabled"};

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void addTransmogTooltipToItemStack(Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir) {
        if (Config.tooltipDetailLevel == TooltipDetailLevel.NONE) {
            return;
        }
        ItemStack thisStack = (ItemStack)this;
        if (TransmogUtils.isItemStackTransmogged(thisStack)) {
            ItemStack appearanceStack = TransmogUtils.getAppearanceItemStack(thisStack, true);
            List originalItemLines = (List)cir.getReturnValue();
            originalItemLines.add(Component.m_237115_((String)"transmog.transmog_description").m_130940_(ChatFormatting.LIGHT_PURPLE));
            originalItemLines.addAll(ItemStackMixin.getTransmogTooltipLines(player, tooltipFlag, appearanceStack));
        }
    }

    @NotNull
    private static List<Component> getTransmogTooltipLines(Player player, TooltipFlag tooltipFlag, ItemStack appearanceStack) {
        List<MutableComponent> components;
        if (TransmogUtils.isHiddenItem(appearanceStack)) {
            components = List.of(Component.m_237115_((String)"transmog.transmog_hidden").m_130940_(ChatFormatting.LIGHT_PURPLE));
        } else if (Config.tooltipDetailLevel == TooltipDetailLevel.MINIMAL) {
            components = new ArrayList<MutableComponent>(List.of(Component.m_237119_().m_7220_(appearanceStack.m_41720_().m_7626_(appearanceStack)).m_130940_(appearanceStack.m_41791_().f_43022_)));
            if (tooltipFlag.m_7050_()) {
                components.add(Component.m_237113_((String)Registry.f_122827_.m_7981_((Object)appearanceStack.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            components = new ArrayList<Component>(appearanceStack.m_41651_(player, tooltipFlag).stream().filter(ItemStackMixin::keepComponent).toList());
            if (((Component)components.get(components.size() - 1)).equals(CommonComponents.f_237098_)) {
                components.remove(components.size() - 1);
            }
        }
        return components;
    }

    private static boolean keepComponent(Component component) {
        if (!(component instanceof MutableComponent)) {
            return true;
        }
        MutableComponent mutableComponent = (MutableComponent)component;
        String[] stringArray = mutableComponent.m_214077_();
        if (stringArray instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)stringArray;
            for (String translationKey : TRANSLATION_KEYS_TO_REMOVE) {
                if (translationKey.endsWith("*") && translatableContents.m_237508_().startsWith(translationKey.replace("*", ""))) {
                    return false;
                }
                if (!translatableContents.m_237508_().equals(translationKey)) continue;
                return false;
            }
        }
        for (Component sibling : mutableComponent.m_7360_()) {
            if (ItemStackMixin.keepComponent(sibling)) continue;
            return false;
        }
        return true;
    }
}

