/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.common.Contributors;
import com.google.common.base.Suppliers;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PaucalAPI {
    public static final String MOD_ID = "paucal";
    public static final String CONTRIBUTOR_URL = "https://raw.githubusercontent.com/gamma-delta/contributors/main/paucal.toml";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"paucal");
    public static final Supplier<PaucalAPI> INSTANCE = Suppliers.memoize(() -> {
        try {
            return (PaucalAPI)Class.forName("at.petrak.paucal.common.impl.PaucalAPIImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.warn("Unable to find a PaucalAPIImpl, using a dummy");
            return new PaucalAPI(){};
        }
    });

    @Nullable
    default public Contributor getContributor(UUID uuid) {
        return Contributors.getContributor(uuid);
    }

    public static PaucalAPI instance() {
        return INSTANCE.get();
    }
}

