/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.api.simple;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.api.simple.ConfigProperty;
import com.mrcrayfish.configured.api.simple.validate.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class ListProperty<T>
extends ConfigProperty<List<T>> {
    public static final Type<Boolean> BOOL = new Type<Boolean>(Boolean.class, new Class[0]);
    public static final Type<Double> DOUBLE = new Type<Double>(Double.class, new Class[0]);
    public static final Type<Integer> INT = new Type<Integer>(Integer.class, new Class[0]);
    public static final Type<Long> LONG = new Type<Long>(Long.class, Integer.class);
    public static final Type<String> STRING = new Type<String>(String.class, new Class[0]);
    private final Supplier<List<T>> defaultList;
    private final Type<T> type;
    private final Validator<T> elementValidator;

    ListProperty(Supplier<List<T>> defaultList, Type<T> type, Validator<T> elementValidator) {
        super(null, (UnmodifiableConfig config, List<String> path) -> (List)config.getOrElse(path, (Object)((List)defaultList.get())));
        this.defaultList = defaultList;
        this.type = type;
        this.elementValidator = elementValidator;
    }

    public Type<T> getType() {
        return this.type;
    }

    @Override
    public List<T> getDefaultValue() {
        return this.defaultList.get();
    }

    @Override
    public boolean isDefault() {
        return ListProperty.compareLists((List)this.get(), this.getDefaultValue(), this.getType());
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.defineList(this.data.getPath(), this.defaultList::get, e -> {
            if (this.type == LONG && this.type.test(e)) {
                e = ((Number)e).longValue();
            }
            return e != null && this.type.test(e) && (this.elementValidator == null || this.elementValidator.test(e));
        });
    }

    @Override
    public boolean isValid(List<T> value) {
        return value != null && value.stream().allMatch(e -> e != null && this.type.test(e) && (this.elementValidator == null || this.elementValidator.test(e)));
    }

    public static <T> ListProperty<T> create(Type<T> type) {
        return ListProperty.create(type, ArrayList::new);
    }

    public static <T> ListProperty<T> create(Type<T> type, Supplier<List<T>> defaultList) {
        return ListProperty.create(type, null, defaultList);
    }

    public static <T> ListProperty<T> create(Type<T> type, Validator<T> elementValidator) {
        return ListProperty.create(type, elementValidator, ArrayList::new);
    }

    public static <T> ListProperty<T> create(Type<T> type, Validator<T> elementValidator, Supplier<List<T>> defaultList) {
        return new ListProperty<T>(defaultList, type, elementValidator);
    }

    public static <T> boolean compareLists(List<T> a, List<T> b, Type<T> type) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (type == LONG) {
                long v1 = ((Number)a.get(i)).longValue();
                long v2 = ((Number)b.get(i)).longValue();
                if (Objects.equals(v1, v2)) continue;
                return false;
            }
            if (Objects.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class Type<T> {
        private final Class<T> classType;
        private final Class<?>[] additionalTypes;

        private Type(Class<T> classType, Class<?> ... additionalTypes) {
            this.classType = classType;
            this.additionalTypes = additionalTypes;
        }

        private boolean test(Object o) {
            Preconditions.checkNotNull((Object)o);
            for (Class<?> validType : this.additionalTypes) {
                if (!validType.isAssignableFrom(o.getClass())) continue;
                return true;
            }
            return this.classType.isAssignableFrom(o.getClass());
        }
    }
}

