/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.PlatformHelper;
import com.affehund.voidtotem.VoidTotemForge;
import com.affehund.voidtotem.api.VoidTotemEvent;
import com.affehund.voidtotem.core.VoidTotemConfig;
import com.affehund.voidtotem.core.network.PacketHandler;
import com.affehund.voidtotem.core.network.TotemEffectPacket;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ForgePlatformHelper
implements PlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public InteractionResult getVoidTotemEventResult(ItemStack itemStack, LivingEntity livingEntity, DamageSource source) {
        VoidTotemEvent event = new VoidTotemEvent(itemStack, livingEntity, source);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult().equals((Object)Event.Result.ALLOW)) {
            return InteractionResult.CONSUME_PARTIAL;
        }
        if (event.getResult().equals((Object)Event.Result.DENY)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public ItemStack getTotemFromAdditionalSlot(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        if (this.isModLoaded("curios")) {
            return CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, filter).map(SlotResult::stack).orElse(null);
        }
        return null;
    }

    @Override
    public Item getVoidTotemItem() {
        return (Item)VoidTotemForge.VOID_TOTEM_ITEM.get();
    }

    @Override
    public void sendTotemEffectPacket(ItemStack itemStack, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketHandler.sendToPlayer(new TotemEffectPacket(itemStack, (Entity)player), player);
        }
        PacketHandler.sendToAllTracking(new TotemEffectPacket(itemStack, (Entity)livingEntity), livingEntity);
    }

    @Override
    public ParticleOptions getVoidTotemParticle() {
        return (ParticleOptions)VoidTotemForge.VOID_TOTEM_PARTICLE.get();
    }

    @Override
    public List<? extends String> getBlacklistedDimensions() {
        return (List)VoidTotemConfig.BLACKLISTED_DIMENSIONS.get();
    }

    @Override
    public boolean giveTotemEffects() {
        return (Boolean)VoidTotemConfig.GIVE_TOTEM_EFFECTS.get();
    }

    @Override
    public boolean isInvertedBlacklist() {
        return (Boolean)VoidTotemConfig.IS_INVERTED_BLACKLIST.get();
    }

    @Override
    public boolean needsTotem() {
        return (Boolean)VoidTotemConfig.NEEDS_TOTEM.get();
    }

    @Override
    public boolean showTotemTooltip() {
        return (Boolean)VoidTotemConfig.SHOW_TOTEM_TOOLTIP.get();
    }

    @Override
    public int teleportHeightOffset() {
        return (Integer)VoidTotemConfig.TELEPORT_HEIGHT_OFFSET.get();
    }

    @Override
    public boolean useTotemFromInventory() {
        return (Boolean)VoidTotemConfig.USE_TOTEM_FROM_INVENTORY.get();
    }
}

