/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.network.IMessage;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.MorphTool;
import vazkii.morphtool.MorphingHandler;
import vazkii.morphtool.network.MessageMorphTool;

@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    protected static boolean autoMode = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        ItemStack mainHandItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && event.phase == TickEvent.Phase.END && autoMode && MorphingHandler.isMorphTool(mainHandItem = player.m_21120_((Boolean)ConfigHandler.invertHandShift.get() != false ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND))) {
            ItemStack newStack = mainHandItem;
            HitResult res = MorphingHandler.raycast((Entity)player, 4.5);
            if (res != null && res.m_6662_() == HitResult.Type.BLOCK) {
                BlockState state = player.f_19853_.m_8055_(((BlockHitResult)res).m_82425_());
                String modlook = MorphingHandler.getModFromState(state);
                newStack = MorphingHandler.getShiftStackForMod(mainHandItem, modlook);
            }
            if (newStack != mainHandItem && !ItemStack.m_41746_((ItemStack)newStack, (ItemStack)mainHandItem)) {
                Inventory inventory = player.m_150109_();
                inventory.m_6836_((Boolean)ConfigHandler.invertHandShift.get() != false ? inventory.m_6643_() - 1 : inventory.f_35977_, newStack);
                MorphTool.NETWORKHANDLER.sendToServer((IMessage)new MessageMorphTool(newStack, inventory.f_35977_));
                MorphTool.proxy.updateEquippedItem();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        ItemStack mainHandItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && MorphingHandler.isMorphTool(mainHandItem = player.m_21120_((Boolean)ConfigHandler.invertHandShift.get() != false ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND))) {
            ItemStack newStack = mainHandItem;
            String mod = MorphingHandler.getModFromStack(mainHandItem);
            HitResult res = MorphingHandler.raycast((Entity)player, 4.5);
            String modlook = "";
            if (res != null && res.m_6662_() == HitResult.Type.BLOCK) {
                BlockState state = player.f_19853_.m_8055_(((BlockHitResult)res).m_82425_());
                modlook = MorphingHandler.getModFromState(state);
            }
            if (event.getScrollDelta() != 0.0 && player.m_6047_() && !modlook.equals(mod) && mainHandItem.m_41783_() != null) {
                CompoundTag morphData = mainHandItem.m_41783_().m_128469_("morphtool:data");
                mod = event.getScrollDelta() < 0.0 ? ClientHandler.nextMod(morphData, mod) : ClientHandler.previousMod(morphData, mod);
                newStack = MorphingHandler.getShiftStackForMod(mainHandItem, mod);
                autoMode = mod.equals("morphtool");
                event.setCanceled(true);
            }
            if (newStack != mainHandItem && !ItemStack.m_41746_((ItemStack)newStack, (ItemStack)mainHandItem)) {
                Inventory inventory = player.m_150109_();
                inventory.m_6836_((Boolean)ConfigHandler.invertHandShift.get() != false ? inventory.m_6643_() - 1 : inventory.f_35977_, newStack);
                MorphTool.NETWORKHANDLER.sendToServer((IMessage)new MessageMorphTool(newStack, inventory.f_35977_));
                MorphTool.proxy.updateEquippedItem();
            }
        }
    }

    public static String nextMod(CompoundTag morphData, String mod) {
        ArrayList<String> mods = new ArrayList<String>(morphData.m_128431_());
        mods.add("morphtool");
        if (!mod.equals("morphtool")) {
            mods.add(mod);
        }
        Collections.sort(mods);
        int id = mods.indexOf(mod);
        int retid = 0;
        if (mods.size() > id + 1) {
            retid = id + 1;
        }
        return (String)mods.get(retid);
    }

    public static String previousMod(CompoundTag morphData, String mod) {
        ArrayList<String> mods = new ArrayList<String>(morphData.m_128431_());
        mods.add("morphtool");
        if (!mod.equals("morphtool")) {
            mods.add(mod);
        }
        Collections.sort(mods);
        int id = mods.indexOf(mod);
        int retid = mods.size() - 1;
        if (0 <= id - 1) {
            retid = id - 1;
        }
        return (String)mods.get(retid);
    }
}

