/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.holder;

import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonObject;
import java.util.Collection;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public abstract class ConfigHolder<T extends ConfigKey>
implements ICreativeConfigHolder {
    public final ConfigSynchronization synchronization;
    public final ICreativeConfigHolder parent;
    public final String[] path;
    protected PairList<String, T> fields = new PairList();

    public ConfigHolder(ICreativeConfigHolder parent, String key, ConfigSynchronization synchronization) {
        this.parent = parent;
        this.path = (String[])ObjectArrays.concat((Object[])parent.path(), (Object)key);
        this.synchronization = synchronization;
    }

    ConfigHolder() {
        this.parent = null;
        this.path = new String[0];
        this.synchronization = ConfigSynchronization.UNIVERSAL;
    }

    @Override
    public ConfigSynchronization synchronization() {
        return this.synchronization;
    }

    @Override
    public ICreativeConfigHolder parent() {
        return this.parent;
    }

    @Override
    public String[] path() {
        return this.path;
    }

    @Override
    public ConfigKey getField(String key) {
        return (ConfigKey)this.fields.getValue(key);
    }

    @Override
    public Collection<? extends ConfigKey> fields() {
        return this.fields.values();
    }

    @Override
    public Collection<String> names() {
        return this.fields.keys();
    }

    @Override
    public Object get(String key) {
        ConfigKey field = (ConfigKey)this.fields.getValue(key);
        if (field != null) {
            return field.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!(field.get() instanceof ICreativeConfigHolder ? !((ICreativeConfigHolder)field.get()).isEmpty(side) : field.is(side))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmptyWithoutForce(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!(field.get() instanceof ICreativeConfigHolder ? !((ICreativeConfigHolder)field.get()).isEmptyWithoutForce(side) : field.isWithoutForce(side))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDefault(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!((ConfigKey)((Pair)this.fields.get((int)i)).value).is(side) || ((ConfigKey)((Pair)this.fields.get((int)i)).value).isDefault(side)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreDefault(Side side, boolean ignoreRestart) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey key = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!key.is(side) || ignoreRestart && key.requiresRestart || key.get() instanceof ICreativeConfigHolder && ((ICreativeConfigHolder)key.get()).isEmpty(side)) continue;
            key.restoreDefault(side, ignoreRestart);
        }
    }

    @Override
    public void load(boolean loadDefault, boolean ignoreRestart, JsonObject json, Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!field.is(side) || ignoreRestart && field.requiresRestart) continue;
            if (json.has(field.name)) {
                field.set(ConfigTypeConveration.read(field.getType(), field.getDefault(), loadDefault, ignoreRestart, json.get(field.name), side, field instanceof ConfigKey.ConfigKeyField ? (ConfigKey.ConfigKeyField)field : null), side);
            } else if (!(!loadDefault || field.get() instanceof ICreativeConfigHolder && ((ICreativeConfigHolder)field.get()).isEmpty(side))) {
                field.restoreDefault(side, ignoreRestart);
            }
            field.triggerConfigured(side);
        }
    }

    @Override
    public JsonObject save(boolean saveDefault, boolean ignoreRestart, Side side) {
        JsonObject object = new JsonObject();
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!field.is(side) || ignoreRestart && field.requiresRestart || !saveDefault && field.isDefault(side)) continue;
            object.add(field.name, ConfigTypeConveration.write(field.getType(), field.get(), field.getDefault(), saveDefault, ignoreRestart, side, field instanceof ConfigKey.ConfigKeyField ? (ConfigKey.ConfigKeyField)field : null));
        }
        return object;
    }
}

