/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGridPreview;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlotViewer;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelectorExtension
extends GuiScrollY {
    public GuiStackSelector comboBox;
    public String search = "";
    protected int cachedWidth;

    public GuiStackSelectorExtension(String name, Player player, GuiStackSelector comboBox) {
        super(name);
        this.comboBox = comboBox;
        this.registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.registerEventClick(event -> {
            if (event.control instanceof GuiSlotViewer && event.control.isParent(this)) {
                comboBox.setSelected(((GuiSlotViewer)event.control).getStack());
                GuiStackSelectorExtension.playSound(SoundEvents.f_12490_);
                comboBox.closeBox();
            }
        });
        this.align = Align.STRETCH;
        this.reloadControls();
        this.setDim(new GuiSizeRule.GuiSizeRules().maxHeight(100));
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            this.comboBox.extensionLostFocus = false;
        }
        return true;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width;
        super.flowX(width, preferred);
    }

    public void reflowInternal() {
        this.flowX(this.cachedWidth, this.preferredWidth(this.cachedWidth));
        this.flowY(this.cachedWidth, this.cachedHeight, this.preferredHeight(this.cachedWidth, this.cachedHeight));
    }

    public void reloadControls() {
        HashMapList<String, ItemStack> stacks;
        if (this.comboBox == null) {
            return;
        }
        HashMapList<String, ItemStack> hashMapList = stacks = this.search == null || this.search.isEmpty() ? this.comboBox.getStacks() : new HashMapList<String, ItemStack>();
        if (this.search != null && !this.search.isEmpty()) {
            for (Map.Entry<String, ArrayList<ItemStack>> entry : this.comboBox.getStacks().entrySet()) {
                for (ItemStack stack : entry.getValue()) {
                    if (!GuiStackSelector.contains(this.search, stack)) continue;
                    stacks.add(entry.getKey(), stack);
                }
            }
        }
        GuiTextfield textfield = (GuiTextfield)this.get("searchBar");
        this.clear();
        if (this.comboBox.searchBar) {
            if (textfield == null) {
                textfield = new GuiTextfield("searchBar", this.search == null ? "" : this.search);
            }
            this.add((GuiControl)textfield);
            textfield.focus();
        }
        for (Map.Entry entry : stacks.entrySet()) {
            this.add((GuiControl)new GuiLabel("title").setTitle((Component)Component.m_237115_((String)((String)entry.getKey()))));
            SimpleContainer container = new SimpleContainer(entry.getValue().size());
            int i = 0;
            for (ItemStack stack : entry.getValue()) {
                container.m_6836_(i, stack);
                ++i;
            }
            this.add((GuiControl)new GuiInventoryGridPreview((String)entry.getKey(), (Container)container));
        }
        if (this.hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public void looseFocus() {
        this.comboBox.extensionLostFocus = true;
    }
}

