/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNf;

public class Vec3f
extends VecNf<Vec3f> {
    public float x;
    public float y;
    public float z;

    public Vec3f() {
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3f(Vec3f vec) {
        super(vec);
    }

    public Vec3f(Vector3f vec) {
        this(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
    }

    public Vec3f(Vec3d vec) {
        this((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public Vector3d toVanilla() {
        return new Vector3d((double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    public void set(Vec3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    @Override
    public float get(Axis axis) {
        return switch (axis) {
            case Axis.X -> this.x;
            case Axis.Y -> this.y;
            case Axis.Z -> this.z;
            default -> 0.0f;
        };
    }

    @Override
    public float get(int dim) {
        return switch (dim) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> 0.0f;
        };
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void set(int dim, float value) {
        switch (dim) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
            }
        }
    }

    @Override
    public void set(Axis axis, float value) {
        switch (axis) {
            case X: {
                this.x = value;
                break;
            }
            case Y: {
                this.y = value;
                break;
            }
            case Z: {
                this.z = value;
            }
        }
    }

    @Override
    public int dimensions() {
        return 3;
    }

    @Override
    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }

    @Override
    public void add(Vec3f vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    @Override
    public void sub(Vec3f vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    @Override
    public void scale(double dScale) {
        float scale = (float)dScale;
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vec3f) {
            return ((Vec3f)obj).x == this.x && ((Vec3f)obj).y == this.y && ((Vec3f)obj).z == this.z;
        }
        return false;
    }

    @Override
    public boolean epsilonEquals(Vec3f var1, float var2) {
        float var3 = this.x - var1.x;
        if (Float.isNaN(var3)) {
            return false;
        }
        float f = var3 < 0.0f ? -var3 : var3;
        if (f > var2) {
            return false;
        }
        var3 = this.y - var1.y;
        if (Float.isNaN(var3)) {
            return false;
        }
        float f2 = var3 < 0.0f ? -var3 : var3;
        if (f2 > var2) {
            return false;
        }
        var3 = this.z - var1.z;
        if (Float.isNaN(var3)) {
            return false;
        }
        return (var3 < 0.0f ? -var3 : var3) <= var2;
    }

    @Override
    public double distance(Vec3f vec) {
        float x = this.x - vec.x;
        float y = this.y - vec.y;
        float z = this.z - vec.z;
        return Math.sqrt(x * x + y * y + z * z);
    }

    @Override
    public double distanceSqr(Vec3f vec) {
        float x = this.x - vec.x;
        float y = this.y - vec.y;
        float z = this.z - vec.z;
        return x * x + y * y + z * z;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double angle(Vec3f vec) {
        double vDot = (double)this.dot(vec) / (this.length() * vec.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    public void cross(Vec3f vec1, Vec3f vec2) {
        this.x = vec1.y * vec2.z - vec1.z * vec2.y;
        this.y = vec2.x * vec1.z - vec2.z * vec1.x;
        this.z = vec1.x * vec2.y - vec1.y * vec2.x;
    }

    @Override
    public float dot(Vec3f vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }
}

