/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket;

import cech12.bucketlib.api.BucketLibApi;
import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.ceramicbucket.config.ServerConfig;
import cech12.ceramicbucket.init.ModTags;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ceramicbucket")
@Mod.EventBusSubscriber(modid="ceramicbucket")
public class CeramicBucketMod {
    public static final String MOD_ID = "ceramicbucket";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ceramicbucket");
    public static final RegistryObject<Item> UNFIRED_CLAY_BUCKET = ITEMS.register("unfired_clay_bucket", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> CERAMIC_BUCKET = ITEMS.register("ceramic_bucket", () -> new UniversalBucketItem(new UniversalBucketItem.Properties().upperCrackingTemperature(ServerConfig.CERAMIC_BUCKET_BREAK_TEMPERATURE).crackingFluids(ModTags.Fluids.CERAMIC_CRACKING).milking(ServerConfig.MILKING_ENABLED).entityObtaining(ServerConfig.FISH_OBTAINING_ENABLED).dyeable(14975336).durability(ServerConfig.CERAMIC_BUCKET_DURABILITY)));
    private static final List<ResourceLocation> oldResourceLocations = Arrays.stream(new String[]{"filled_ceramic_bucket", "ceramic_milk_bucket", "ceramic_entity_bucket", "pufferfish_ceramic_bucket", "salmon_ceramic_bucket", "cod_ceramic_bucket", "tropical_fish_ceramic_bucket"}).map(oldId -> new ResourceLocation(MOD_ID, oldId)).toList();

    public CeramicBucketMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        ServerConfig.loadConfig(ServerConfig.SERVER_CONFIG, FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("ceramicbucket-server.toml"));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
    }

    private void sendImc(InterModEnqueueEvent evt) {
        BucketLibApi.registerBucket((ResourceLocation)CERAMIC_BUCKET.getId());
    }

    @SubscribeEvent
    public static void remapOldIds(MissingMappingsEvent event) {
        event.getMappings(ForgeRegistries.ITEMS.getRegistryKey(), MOD_ID).forEach(itemMapping -> {
            if (oldResourceLocations.stream().anyMatch(arg_0 -> ((ResourceLocation)itemMapping.getKey()).equals(arg_0))) {
                itemMapping.remap((Object)((Item)CERAMIC_BUCKET.get()));
            }
        });
    }
}

